var tableApp = angular.module('tableApp', [
	'ui.bootstrap',
	'tableControllers',
	'tableServices',
]);

var tableControllers = angular.module('tableControllers', []);
tableControllers.controller('TableCtrl', ['$scope', 'Records',
	function($scope, Records) {
		$scope.counts = Records.query();
		$scope.showModel = {
			COL01: true,
			COL02: true,
			COL03: true,
			COL04: true,
			COL05: true,
			COL06: true,
			COL07: true,
			COL08: true,
			COL09: true,
		};
		$scope.maxSize = 7;
		$scope.itemPerPage = 20;
		$scope.currentPage = 1;
		$scope.parseDate = function(str) {
			var m = str.match(/\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}.\d{3}/);
			return new Date(m);
		};
		$scope.export = function() {
			document.location.href = '../../api/${WEB.subDirectory}.xfp/download';
    	};
		$scope.filedn = function(id,name) {
			var obj = $(event.relatedTarget);
			document.location.href = '../../api/${WEB.subDirectory}.xfp/filedownload?fileid=' + id + '&filename=' + name;
    	};
	}]
);

var tableServices = angular.module('tableServices', ['ngResource']);
tableServices.factory('Records', ['$resource',
	function($resource) {
		return $resource('../../api/${WEB.subDirectory}.xfp/get', {}, {
			query: {method: 'GET', params: {}, isArray: false}
		});
	}
]);
