var tableApp = angular.module('tableApp', [
	'ui.bootstrap',
	'tableControllers',
	'tableServices',
]);

var tableControllers = angular.module('tableControllers', []);
tableControllers.controller('TableCtrl', ['$scope', 'Records',
	function($scope, Records) {
		$scope.counts = Records.query();
		$scope.showModel = {
#foreach ($col in $TABLE.table.getColumnList())
			$col: true,
#end
		};
		$scope.maxSize = 7;
		$scope.itemPerPage = 10;
		$scope.currentPage = 1;
		$scope.parseDate = function(str) {
			var m = str.match(/\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}.\d{3}/);
			return new Date(m);
		};
		$scope.export = function() {
			document.location.href = 'api/${WEB.subDirectory}.xfp/download';
    	};
		$scope.create = function() {
			document.createform.action = 'api/${WEB.subDirectory}.xfp/create';
			document.createform.submit();
    	};
		$scope.update = function() {
			document.updateform.action = 'api/${WEB.subDirectory}.xfp/update';
			document.updateform.submit();
    	};
		$scope.delete = function() {
			document.deleteform.action = 'api/${WEB.subDirectory}.xfp/delete';
			document.deleteform.submit();
    	};
	}]
);

var tableServices = angular.module('tableServices', ['ngResource']);
tableServices.factory('Records', ['$resource',
	function($resource) {
		return $resource('api/${WEB.subDirectory}.xfp/read', {}, {
			query: {method: 'GET', params: {}, isArray: false}
		});
	}
]);


