/*
 * Decompiled with CFR 0.152.
 */
package com.infoteria.asteria.flowlibrary2.component.format.builder;

import com.infoteria.asteria.flowbuilder2.Application;
import com.infoteria.asteria.flowbuilder2.base.BaseHolder;
import com.infoteria.asteria.flowbuilder2.base.Connector;
import com.infoteria.asteria.flowbuilder2.base.ConnectorSet;
import com.infoteria.asteria.flowbuilder2.command.ConnectorAliasChangeCommand;
import com.infoteria.asteria.flowbuilder2.command.ConnectorCommand;
import com.infoteria.asteria.flowbuilder2.component.Component;
import com.infoteria.asteria.flowbuilder2.component.ComponentConnector;
import com.infoteria.asteria.flowbuilder2.component.ComponentInputConnector;
import com.infoteria.asteria.flowbuilder2.component.ComponentOutputConnector;
import com.infoteria.asteria.flowbuilder2.core.CoreUtil;
import com.infoteria.asteria.flowbuilder2.dialog.MessageDialog;
import com.infoteria.asteria.flowbuilder2.flow.FlowContext;
import com.infoteria.asteria.flowbuilder2.property.FlowProperty;
import com.infoteria.asteria.flowbuilder2.property.category.CategoryItem;
import com.infoteria.asteria.flowbuilder2.property.category.CategoryProperty;
import com.infoteria.asteria.flowbuilder2.util.TileIcon;
import com.infoteria.asteria.util.xml.DOMUtil;
import com.infoteria.gui.property.Property;
import com.infoteria.gui.property.PropertyException;
import com.infoteria.gui.property.PropertyUtil;
import com.infoteria.gui.property.XMLDocumentProperty;
import com.infoteria.gui.property.event.PropertyChangeEvent;
import com.infoteria.gui.property.event.PropertyChangeListener;
import com.infoteria.gui.property.event.PropertyChangeVetoException;
import com.infoteria.gui.util.MetaData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.undo.UndoableEdit;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelMappingPropertyListener
implements PropertyChangeListener,
MetaData {
    private static final String _E_COMPONENT = "component";
    private static final String _E_HEADER = "header";
    private static final String _E_TEXT = "text";
    private static final String _E_RECORDS = "records";
    private static final String _E_TABLE = "table";
    private static final String _A_NAME = "name";
    private static final String _A_AREA = "area";
    private static final String _COLUMN_NAME = "Name";
    private static final String _COLUMN_DEFAULT = "Default";
    private static final String _COLUMN_MODE = "Mode";
    private static final String A_MODE = "mode";
    private boolean _bInput = false;

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException();
        }
    }

    public void setup(Element element) {
        this._bInput = "Input".equalsIgnoreCase(element.getAttribute(A_MODE));
    }

    private String extractSheetName(String string) {
        int n = string.indexOf(33);
        if (n == -1) {
            return null;
        }
        return string.substring(0, n);
    }

    private List<String> getSheetNameList(Document document, List<String> list) {
        Object object;
        String string;
        Node node;
        Element element = DOMUtil.getChild((Node)document.getDocumentElement(), (String)_E_COMPONENT);
        if (element == null) {
            return list;
        }
        Element element2 = DOMUtil.getChild((Node)element, (String)_E_HEADER);
        if (element2 != null) {
            for (node = element2.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!DOMUtil.isQName((Node)node, null, (String)_E_TEXT) || (string = this.extractSheetName((String)(object = ((Element)node).getAttribute(_A_AREA)))) == null || list.indexOf(string) != -1) continue;
                list.add(string);
            }
        }
        if ((node = DOMUtil.getChild((Node)element, (String)_E_RECORDS)) != null) {
            for (object = node.getFirstChild(); object != null; object = object.getNextSibling()) {
                String string2;
                if (!DOMUtil.isQName((Node)object, null, (String)_E_TABLE) || (string2 = this.extractSheetName(string = ((Element)object).getAttribute(_A_AREA))) == null || list.indexOf(string2) != -1) continue;
                list.add(string2);
            }
        }
        return list;
    }

    public void propertyChanged(PropertyChangeEvent propertyChangeEvent) {
        Component component = (Component)propertyChangeEvent.getProperty().getOwner();
        CategoryProperty categoryProperty = (CategoryProperty)component.getAdditionalProperty("Sheet");
        if (categoryProperty.getRowCount() != 0) {
            return;
        }
        Property property = this._bInput ? component.getProperty("InputSheetName") : component.getProperty("OutputSheetName");
        String string = property.getValueAsString();
        String string2 = this._bInput ? null : component.getProperty("OutputSheetCreateMode").getValueAsString();
        XMLDocumentProperty xMLDocumentProperty = (XMLDocumentProperty)PropertyUtil.getNakedProperty((Property)component.getProperty("EMF"));
        List<String> list = this.getSheetNameList(xMLDocumentProperty.getDocument(), new ArrayList<String>());
        for (int i = 0; i < list.size(); ++i) {
            String string3 = list.get(i);
            CategoryItem categoryItem = categoryProperty.createNewItem();
            categoryItem.setValue(_COLUMN_NAME, (Object)string3);
            if (i == 0) {
                if (string != null && string.length() != 0) {
                    categoryItem.setValue(_COLUMN_DEFAULT, (Object)string);
                    try {
                        property.setValue((Object)"");
                    }
                    catch (PropertyException propertyException) {
                        propertyException.printStackTrace();
                    }
                }
                if (!this._bInput) {
                    categoryItem.setValue(_COLUMN_MODE, (Object)string2);
                }
            }
            categoryProperty.addItem(categoryItem);
            if (i != 0) continue;
            String string4 = "mapping=CP/CP:" + component.getName() + "/" + categoryProperty.getName() + "/" + categoryItem.getName();
            ((FlowProperty)property).setConversionHint(string4);
        }
    }

    private void updateIcon(Component component, List<String> list) {
        Icon icon = list != null && list.size() > 0 ? new TileIcon(component.getMetaData().getIcon(), Collections.nCopies(list.size(), ""), false) : component.getMetaData().getIcon();
        component.setIcon(icon);
        component.setupDrawInfo();
        Iterator iterator = component.getOutputConnectors();
        while (iterator.hasNext()) {
            Connector connector = (Connector)iterator.next();
            for (int i = 0; i < connector.getLinkCount(); ++i) {
                connector.getLink(i).validate();
            }
        }
        component.fireStateChanged();
    }

    private ComponentConnector createOutputConnector(String string) {
        ComponentOutputConnector componentOutputConnector = new ComponentOutputConnector(string);
        componentOutputConnector.setAcceptStreamFormat(16);
        componentOutputConnector.setDefaultStreamFormat(16);
        componentOutputConnector.setAcceptLinkCount(-1);
        componentOutputConnector.setup();
        componentOutputConnector.getStreamDefinition().getFieldDefinition().addReadOnlyColumn(_COLUMN_NAME);
        return componentOutputConnector;
    }

    private ComponentConnector createInputConnector(String string) {
        ComponentInputConnector componentInputConnector = new ComponentInputConnector(string);
        componentInputConnector.setAcceptStreamFormat(16);
        componentInputConnector.setDefaultStreamFormat(16);
        componentInputConnector.setDefineStream(true);
        componentInputConnector.setup();
        componentInputConnector.getStreamDefinition().getFieldDefinition().addReadOnlyColumn(_COLUMN_NAME);
        return componentInputConnector;
    }

    public void propertyChanging(PropertyChangeEvent propertyChangeEvent) throws PropertyChangeVetoException {
        String string;
        Object object;
        Object object2;
        Node node;
        Element element;
        ArrayList<String> arrayList = new ArrayList<String>();
        Component component = (Component)propertyChangeEvent.getProperty().getOwner();
        Document document = (Document)propertyChangeEvent.getNewValue();
        Element element2 = document.getDocumentElement();
        Element element3 = DOMUtil.getChild((Node)element2, (String)_E_COMPONENT);
        if (element3 != null && (element = DOMUtil.getChild((Node)element3, (String)_E_RECORDS)) != null) {
            for (node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!DOMUtil.isQName((Node)node, null, (String)_E_TABLE)) continue;
                object2 = ((Element)node).getAttribute(_A_NAME);
                if (((String)object2).length() == 0) {
                    object2 = arrayList.size() == 0 ? "default" : Integer.toString(arrayList.size() + 1);
                }
                arrayList.add((String)object2);
            }
        }
        int n = arrayList.size();
        node = this._bInput ? component.getOutputConnectorSet(0) : component.getInputConnectorSet();
        object2 = node.getConnectors();
        int n2 = ((Connector[])object2).length;
        for (int i = 0; i < Math.min(n2, n); ++i) {
            object = object2[i].getAlias();
            string = (String)arrayList.get(i);
            object2[i].setAlias(string);
            propertyChangeEvent.addUndo((UndoableEdit)new ConnectorAliasChangeCommand(component, (ConnectorSet)node, (Connector)object2[i], (String)object, string));
        }
        if (n > n2) {
            ArrayList<ComponentConnector> arrayList2 = new ArrayList<ComponentConnector>();
            for (int i = n2; i < n; ++i) {
                string = i == 0 ? "default" : Integer.toString(i + 1);
                ComponentConnector componentConnector = this._bInput ? this.createOutputConnector(string) : this.createInputConnector(string);
                componentConnector.setAlias((String)arrayList.get(i));
                node.addSubConnector((Connector)componentConnector);
                arrayList2.add(componentConnector);
            }
            propertyChangeEvent.addUndo((UndoableEdit)new ConnectorCommand(component, (ConnectorSet)node, arrayList2, n2, true));
        } else {
            Object object3;
            ArrayList<Object> arrayList3 = new ArrayList<Object>();
            object = new ArrayList();
            int n3 = Math.max(1, n);
            for (int i = n2 - 1; i > n3 - 1; --i) {
                object3 = object2[i];
                arrayList3.add(object3);
                for (int j = object3.getLinkCount() - 1; j >= 0; --j) {
                    object.add(object3.getLink(j));
                }
            }
            if (object.size() > 0) {
                String string2 = component.getMetaData().getResource("ConfirmMessage");
                if (MessageDialog.showConfirm((String)string2, (int)0) != 0) {
                    throw new PropertyChangeVetoException();
                }
                object3 = (FlowContext)Application.getInstance().getCurrentContext();
                propertyChangeEvent.addUndo(CoreUtil.removeLinks((BaseHolder)object3.getFlow(), (List)object));
            }
            for (int i = 0; i < arrayList3.size(); ++i) {
                node.removeSubConnector((Connector)arrayList3.get(i));
            }
            propertyChangeEvent.addUndo((UndoableEdit)new ConnectorCommand(component, (ConnectorSet)node, arrayList3, n3, false));
        }
        this.updateIcon(component, arrayList);
    }
}

