/*
 * Decompiled with CFR 0.152.
 */
package com.infoteria.asteria.flowlibrary2.component.format;

import com.infoteria.asteria.flowlibrary2.FlowException;
import com.infoteria.asteria.flowlibrary2.component.format.ExcelCellAttributes;
import com.infoteria.asteria.flowlibrary2.component.format.ExcelColor;
import com.infoteria.asteria.flowlibrary2.component.format.ExcelUtil;
import com.infoteria.asteria.flowlibrary2.component.format.ExcelWorkbook;
import com.infoteria.asteria.flowlibrary2.component.format.ExcelWorksheet;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Date;
import jxl.BooleanCell;
import jxl.Cell;
import jxl.CellFeatures;
import jxl.CellReferenceHelper;
import jxl.CellType;
import jxl.DateCell;
import jxl.ErrorCell;
import jxl.FormulaCell;
import jxl.LabelCell;
import jxl.NumberCell;
import jxl.NumberFormulaCell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.biff.FontRecord;
import jxl.biff.formula.FormulaException;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.format.Font;
import jxl.format.Format;
import jxl.format.Pattern;
import jxl.read.biff.BiffException;
import jxl.write.Blank;
import jxl.write.Boolean;
import jxl.write.DateTime;
import jxl.write.Formula;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableCellFeatures;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;

public class ExcelUtilJExcelApi
extends ExcelUtil {
    private long _timezoneOffset = Calendar.getInstance().getTimeZone().getRawOffset();
    private static DecimalFormat format17 = new DecimalFormat("0.0000000000000000E0");

    public boolean initialize() throws FlowException {
        return true;
    }

    public void terminate() {
    }

    public boolean dateSupported() {
        return false;
    }

    public boolean booleanSupported() {
        return true;
    }

    public ExcelWorkbook openWorkbook(byte[] byArray, boolean bl) throws IOException {
        return new ExcelWorkbookImpl(byArray, bl);
    }

    public ExcelWorkbook openWorkbook(String string, boolean bl) throws IOException {
        return new ExcelWorkbookImpl(string, bl);
    }

    public ExcelCellAttributes createCellAttributes(int n) {
        return new ExcelCellAttributesImpl(n);
    }

    public static Double round16(double d) {
        int n = d < 0.0 ? 1 : 0;
        String string = format17.format(d);
        BigDecimal bigDecimal = new BigDecimal(string.substring(0, n + 18));
        return Double.valueOf(bigDecimal.setScale(14, 4).toString() + string.substring(n + 18));
    }

    private static class ExcelCellAttributesImpl
    extends ExcelCellAttributes {
        private static final Colour[] _colours = new Colour[]{Colour.WHITE2, Colour.RED2, Colour.BRIGHT_GREEN2, Colour.BLUE3, Colour.YELLOW3, Colour.PINK3, Colour.TURQUOISE2, Colour.PALETTE_BLACK, Colour.WHITE, Colour.RED, Colour.BRIGHT_GREEN, Colour.BLUE, Colour.YELLOW, Colour.PINK, Colour.TURQUOISE, Colour.DARK_RED, Colour.GREEN, Colour.DARK_BLUE, Colour.DARK_YELLOW, Colour.VIOLET, Colour.TEAL, Colour.GREY_25_PERCENT, Colour.GREY_50_PERCENT, Colour.PERIWINKLE, Colour.PLUM2, Colour.IVORY, Colour.LIGHT_TURQUOISE2, Colour.DARK_PURPLE, Colour.CORAL, Colour.OCEAN_BLUE, Colour.ICE_BLUE, Colour.DARK_BLUE2, Colour.PINK2, Colour.YELLOW2, Colour.TURQOISE2, Colour.VIOLET2, Colour.DARK_RED2, Colour.TEAL2, Colour.BLUE2, Colour.SKY_BLUE, Colour.LIGHT_TURQUOISE, Colour.LIGHT_GREEN, Colour.VERY_LIGHT_YELLOW, Colour.PALE_BLUE, Colour.ROSE, Colour.LAVENDER, Colour.TAN, Colour.LIGHT_BLUE, Colour.AQUA, Colour.LIME, Colour.GOLD, Colour.LIGHT_ORANGE, Colour.ORANGE, Colour.BLUE_GREY, Colour.GREY_40_PERCENT, Colour.DARK_TEAL, Colour.SEA_GREEN, Colour.DARK_GREEN, Colour.OLIVE_GREEN, Colour.BROWN, Colour.PLUM, Colour.INDIGO, Colour.GREY_80_PERCENT, Colour.AUTOMATIC};
        private CellFormat _format;
        private CellFeatures _features;
        private String _formula;
        private ExcelColor _background;
        private ExcelColor _foreground;
        private static final int BOLDWEIGHT_NORMAL = 400;

        ExcelCellAttributesImpl(int n) {
            super(n);
        }

        void initCellFormat(CellFormat cellFormat) {
            this._format = cellFormat;
            Colour colour = this._format.getBackgroundColour();
            this._background = ExcelColor.getColor(colour.getValue());
            if (this._background == null) {
                this._background = ExcelColor.getWhiteColor();
            }
            colour = this._format.getFont().getColour();
            this._foreground = ExcelColor.getColor(colour.getValue());
            if (this._foreground == null) {
                this._foreground = ExcelColor.getBlackColor();
            }
        }

        void initCellFeatures(CellFeatures cellFeatures) {
            this._features = cellFeatures;
        }

        void initCellFormula(String string) {
            this._formula = string;
        }

        static Colour excelColorToColour(ExcelColor excelColor) {
            int n = excelColor.getIndex();
            if (n <= 0 || n - 1 >= _colours.length) {
                if (n == 0) {
                    return Colour.DEFAULT_BACKGROUND1;
                }
                if (n == 64) {
                    return Colour.AUTOMATIC;
                }
                if (n == 192) {
                    return Colour.DEFAULT_BACKGROUND;
                }
                if (n == 32750) {
                    return Colour.UNKNOWN;
                }
                if (n == Short.MAX_VALUE) {
                    return Colour.BLACK;
                }
                return null;
            }
            return _colours[n - 1];
        }

        public ExcelColor getBackgroundColor() {
            return this._background;
        }

        public String getComment() {
            return this._features == null ? null : this._features.getComment();
        }

        public String getFontName() {
            return this._format.getFont().getName();
        }

        public int getFontSize() {
            return this._format.getFont().getPointSize();
        }

        public int getFontStyle() {
            int n = 0;
            Font font = this._format.getFont();
            if (font.getBoldWeight() > 400) {
                ++n;
            }
            if (font.isItalic()) {
                n += 2;
            }
            return n;
        }

        public ExcelColor getForegroundColor() {
            return this._foreground;
        }

        public String getFormatPattern() {
            Format format = this._format.getFormat();
            return format == null ? null : format.getFormatString();
        }

        public String getFormula() {
            return this._formula;
        }
    }

    private class ExcelWorksheetImpl
    implements ExcelWorksheet {
        private ExcelWorkbookImpl _book;
        private Sheet _sheet;

        ExcelWorksheetImpl(ExcelWorkbookImpl excelWorkbookImpl, Sheet sheet) {
            this._book = excelWorkbookImpl;
            this._sheet = sheet;
        }

        public String getSheetName() {
            return this._sheet.getName();
        }

        public Object getValue(String string) {
            Cell cell = null;
            try {
                cell = this._sheet.getCell(string);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (cell == null) {
                return null;
            }
            if (cell instanceof LabelCell) {
                return cell.getContents();
            }
            if (cell instanceof BooleanCell) {
                return ((BooleanCell)cell).getValue() ? java.lang.Boolean.TRUE : java.lang.Boolean.FALSE;
            }
            if (cell instanceof NumberCell) {
                long l;
                String string2;
                int n;
                double d = ((NumberCell)cell).getValue();
                if (this._book.getRoundUpFormula() && cell instanceof NumberFormulaCell && (n = (string2 = String.valueOf(d)).length()) > 15) {
                    int n2;
                    int n3;
                    int n4 = string2.indexOf(101);
                    if (n4 != -1 || (n4 = string2.indexOf(69)) != -1) {
                        n = n4;
                    }
                    if ((n3 = string2.indexOf(46)) != -1 && (n4 == -1 || n3 < n4)) {
                        --n;
                    }
                    if ((n2 = string2.indexOf(45)) != -1 && (n4 == -1 || n2 < n4)) {
                        --n;
                    }
                    if (n > 15) {
                        d = ExcelUtil.round16(d);
                    }
                }
                if ((double)(l = (long)d) == d) {
                    return new Long(l);
                }
                return new Double(d);
            }
            if (cell instanceof DateCell) {
                Date date = ((DateCell)cell).getDate();
                long l = date.getTime() - ExcelUtilJExcelApi.this._timezoneOffset;
                return new Date(l);
            }
            if (cell instanceof ErrorCell) {
                return cell.getContents() + "?";
            }
            return null;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean setValue(String string, Object object, ExcelCellAttributes excelCellAttributes) {
            String string2;
            if (!(this._sheet instanceof WritableSheet)) {
                throw new ExcelUtil.WriteException("read only");
            }
            Object object2 = null;
            CellFeatures cellFeatures = null;
            Cell cell = null;
            try {
                cell = this._sheet.getCell(string);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (cell != null) {
                object2 = cell.getCellFormat();
                if (excelCellAttributes != null && excelCellAttributes.hasComment()) {
                    cellFeatures = cell.getCellFeatures();
                }
            }
            int n = CellReferenceHelper.getColumn((String)string);
            int n2 = CellReferenceHelper.getRow((String)string);
            Blank blank = null;
            if (excelCellAttributes != null && excelCellAttributes.hasFormula()) {
                string2 = excelCellAttributes.getFormula();
                if (string2.startsWith("=")) {
                    string2 = string2.substring(1);
                }
                blank = new Formula(n, n2, string2);
            } else if (object == null || object instanceof String && ((String)object).length() == 0) {
                if ((cell == null || cell.getType() == CellType.EMPTY) && excelCellAttributes == null) {
                    return true;
                }
                blank = new Blank(n, n2);
            } else if (object instanceof String) {
                blank = new Label(n, n2, (String)object);
            } else if (object instanceof java.lang.Boolean) {
                blank = new Boolean(n, n2, ((java.lang.Boolean)object).booleanValue());
            } else if (object instanceof java.lang.Number) {
                blank = new Number(n, n2, ((java.lang.Number)object).doubleValue());
            } else if (object instanceof Date) {
                blank = new DateTime(n, n2, (Date)object);
            }
            if (object2 != null || excelCellAttributes != null && excelCellAttributes.hasCellFormat()) {
                if (excelCellAttributes != null && excelCellAttributes.hasCellFormat()) {
                    string2 = object2 == null ? new WritableCellFormat() : new WritableCellFormat(object2);
                    try {
                        if (excelCellAttributes.hasBackgroundColor()) {
                            string2.setBackground(ExcelCellAttributesImpl.excelColorToColour(excelCellAttributes.getBackgroundColor()), Pattern.SOLID);
                        }
                        if (excelCellAttributes.hasFontFormat()) {
                            WritableFont writableFont = excelCellAttributes.hasFontName() ? new WritableFont(WritableFont.createFont((String)excelCellAttributes.getFontName())) : new WritableFont(string2.getFont());
                            if (excelCellAttributes.hasForegroundColor()) {
                                writableFont.setColour(ExcelCellAttributesImpl.excelColorToColour(excelCellAttributes.getForegroundColor()));
                            }
                            if (excelCellAttributes.hasFontSize()) {
                                writableFont.setPointSize(excelCellAttributes.getFontSize());
                            }
                            if (excelCellAttributes.hasFontStyle()) {
                                int n3 = excelCellAttributes.getFontStyle();
                                if ((n3 & 1) != 0) {
                                    writableFont.setBoldStyle(WritableFont.BOLD);
                                } else {
                                    writableFont.setBoldStyle(WritableFont.NO_BOLD);
                                }
                                writableFont.setItalic((n3 & 2) != 0);
                            }
                            string2.setFont((FontRecord)writableFont);
                        }
                        if (!excelCellAttributes.hasFormatPattern()) {
                            // empty if block
                        }
                    }
                    catch (WriteException writeException) {
                        throw new ExcelUtil.WriteException(writeException.toString());
                    }
                    object2 = string2;
                }
                blank.setCellFormat(object2);
            }
            if (excelCellAttributes != null && excelCellAttributes.hasComment()) {
                string2 = cellFeatures == null ? new WritableCellFeatures() : new WritableCellFeatures(cellFeatures);
                string2.setComment(excelCellAttributes.getComment());
                blank.setCellFeatures((WritableCellFeatures)string2);
            }
            try {
                ((WritableSheet)this._sheet).addCell((WritableCell)blank);
                return true;
            }
            catch (RowsExceededException rowsExceededException) {
                throw new ExcelUtil.WriteException(rowsExceededException.toString());
            }
            catch (WriteException writeException) {
                throw new ExcelUtil.WriteException(writeException.toString());
            }
        }

        public boolean clearValue(String string) {
            return this.clearValue(string, true);
        }

        private boolean clearValue(String string, boolean bl) {
            if (!(this._sheet instanceof WritableSheet)) {
                throw new ExcelUtil.WriteException("read only");
            }
            CellFormat cellFormat = null;
            Cell cell = null;
            try {
                cell = this._sheet.getCell(string);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (cell != null) {
                if (bl) {
                    if (cell.getType() == CellType.EMPTY) {
                        return true;
                    }
                    cellFormat = cell.getCellFormat();
                }
                Blank blank = cellFormat == null ? new Blank(cell.getColumn(), cell.getRow()) : new Blank(cell.getColumn(), cell.getRow(), cellFormat);
                try {
                    ((WritableSheet)this._sheet).addCell((WritableCell)blank);
                }
                catch (RowsExceededException rowsExceededException) {
                    throw new ExcelUtil.WriteException(rowsExceededException.toString());
                }
                catch (WriteException writeException) {
                    throw new ExcelUtil.WriteException(writeException.toString());
                }
            }
            return true;
        }

        public ExcelCellAttributes getAttrbutes(String string, int n) {
            Cell cell = null;
            try {
                cell = this._sheet.getCell(string);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (cell == null) {
                return null;
            }
            ExcelCellAttributesImpl excelCellAttributesImpl = new ExcelCellAttributesImpl(n);
            if (excelCellAttributesImpl.hasCellFormat()) {
                excelCellAttributesImpl.initCellFormat(cell.getCellFormat());
            }
            if (excelCellAttributesImpl.hasComment()) {
                excelCellAttributesImpl.initCellFeatures(cell.getCellFeatures());
            }
            if (excelCellAttributesImpl.hasFormula() && cell instanceof FormulaCell) {
                try {
                    excelCellAttributesImpl.initCellFormula(((FormulaCell)cell).getFormula());
                }
                catch (FormulaException formulaException) {
                    // empty catch block
                }
            }
            return excelCellAttributesImpl;
        }
    }

    private class ExcelWorkbookImpl
    implements ExcelWorkbook {
        private Workbook _book;
        private WritableWorkbook _writableBook;
        private ByteArrayOutputStream _outputStream;
        private boolean _roundUpForumla = false;
        private WorkbookSettings _settings = new WorkbookSettings();

        ExcelWorkbookImpl(byte[] byArray, boolean bl) throws IOException {
            this._settings.setGCDisabled(true);
            try {
                if (byArray == null) {
                    if (bl) {
                        throw new IOException("no input stream");
                    }
                    this._outputStream = new ByteArrayOutputStream();
                    this._writableBook = Workbook.createWorkbook((OutputStream)this._outputStream, (WorkbookSettings)this._settings);
                    this.createWorksheet("Sheet1");
                    this.createWorksheet("Sheet2");
                    this.createWorksheet("Sheet3");
                } else {
                    Workbook workbook = Workbook.getWorkbook((InputStream)new ByteArrayInputStream(byArray), (WorkbookSettings)this._settings);
                    if (bl) {
                        this._book = workbook;
                    } else {
                        this._outputStream = new ByteArrayOutputStream();
                        this._writableBook = Workbook.createWorkbook((OutputStream)this._outputStream, (Workbook)workbook, (WorkbookSettings)this._settings);
                    }
                }
            }
            catch (BiffException biffException) {
                throw new ExcelUtil.UnsupportedExcelFileException(biffException.getLocalizedMessage());
            }
        }

        ExcelWorkbookImpl(String string, boolean bl) throws IOException {
            this._settings.setGCDisabled(true);
            File file = string == null ? null : new File(string);
            try {
                if (file == null || !file.exists()) {
                    if (bl) {
                        throw new IOException("no input file");
                    }
                    this._outputStream = new ByteArrayOutputStream();
                    this._writableBook = Workbook.createWorkbook((OutputStream)this._outputStream, (WorkbookSettings)this._settings);
                    this.createWorksheet("Sheet1");
                    this.createWorksheet("Sheet2");
                    this.createWorksheet("Sheet3");
                } else {
                    Workbook workbook = Workbook.getWorkbook((File)file, (WorkbookSettings)this._settings);
                    if (bl) {
                        this._book = workbook;
                    } else {
                        this._outputStream = new ByteArrayOutputStream();
                        this._writableBook = Workbook.createWorkbook((OutputStream)this._outputStream, (Workbook)workbook, (WorkbookSettings)this._settings);
                    }
                }
            }
            catch (BiffException biffException) {
                throw new ExcelUtil.UnsupportedExcelFileException(biffException.getLocalizedMessage());
            }
        }

        public void setAutoCalculation(boolean bl) {
        }

        public void setRoundUpFormula(boolean bl) {
            this._roundUpForumla = bl;
        }

        public boolean getRoundUpFormula() {
            return this._roundUpForumla;
        }

        public byte[] close(String string, boolean bl, boolean bl2) throws IOException {
            if (this._writableBook != null) {
                if (bl || bl2) {
                    this._writableBook.write();
                    try {
                        this._writableBook.close();
                    }
                    catch (WriteException writeException) {
                        throw new IOException(writeException.toString());
                    }
                    byte[] byArray = this._outputStream.toByteArray();
                    if (bl) {
                        File file = new File(string);
                        File file2 = file.getParentFile();
                        if (!file2.exists() && !file2.mkdirs()) {
                            throw new IOException("cannot create directory," + file2.getAbsolutePath());
                        }
                        FileOutputStream fileOutputStream = new FileOutputStream(string);
                        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                        bufferedOutputStream.write(byArray);
                        bufferedOutputStream.close();
                    }
                    return byArray;
                }
                try {
                    this._writableBook.close();
                }
                catch (WriteException writeException) {
                    throw new IOException(writeException.toString());
                }
            }
            if (this._book != null) {
                this._book.close();
            }
            return new byte[0];
        }

        public ExcelWorksheet getWorksheet(String string) {
            Sheet sheet;
            Object object = this._book != null ? this._book.getSheet(string) : (sheet = this._writableBook != null ? this._writableBook.getSheet(string) : null);
            if (sheet == null) {
                return null;
            }
            return new ExcelWorksheetImpl(this, sheet);
        }

        public ExcelWorksheet createWorksheet(String string) {
            if (this._writableBook == null) {
                return null;
            }
            WritableSheet writableSheet = this._writableBook.createSheet(string, this._writableBook.getNumberOfSheets());
            return new ExcelWorksheetImpl(this, (Sheet)writableSheet);
        }

        public ExcelWorksheet copyWorksheet(String string, String string2) {
            if (this._writableBook == null) {
                return null;
            }
            this._writableBook.copySheet(string, string2, this._writableBook.getNumberOfSheets());
            WritableSheet writableSheet = this._writableBook.getSheet(string2);
            if (writableSheet == null) {
                return null;
            }
            return new ExcelWorksheetImpl(this, (Sheet)writableSheet);
        }
    }
}

