/*
 * Decompiled with CFR 0.152.
 */
package com.infoteria.asteria.flowlibrary2.component.format;

import com.extentech.ExtenXLS.CellHandle;
import com.extentech.ExtenXLS.FormatHandle;
import com.extentech.ExtenXLS.FormulaHandle;
import com.extentech.ExtenXLS.WorkBook;
import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.ExtenXLS.WorkSheetHandle;
import com.extentech.formats.XLS.CellNotFoundException;
import com.extentech.formats.XLS.CellTypeMismatchException;
import com.extentech.formats.XLS.FormulaNotFoundException;
import com.extentech.formats.XLS.WorkBookException;
import com.extentech.formats.XLS.WorkSheetNotFoundException;
import com.infoteria.asteria.flowlibrary2.FlowException;
import com.infoteria.asteria.flowlibrary2.component.format.ExcelCellAttributes;
import com.infoteria.asteria.flowlibrary2.component.format.ExcelColor;
import com.infoteria.asteria.flowlibrary2.component.format.ExcelLicenseManager;
import com.infoteria.asteria.flowlibrary2.component.format.ExcelUtil;
import com.infoteria.asteria.flowlibrary2.component.format.ExcelWorkbook;
import com.infoteria.asteria.flowlibrary2.component.format.ExcelWorksheet;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class ExcelUtilExtenXLS
extends ExcelUtil {
    private boolean _shareDupeStringCell = true;

    public boolean initialize() throws FlowException {
        ExcelLicenseManager.setExtenXLSLicense();
        System.setProperty("com.extentech.ExtenXLS.sharedupes", String.valueOf(this._shareDupeStringCell));
        return true;
    }

    public void terminate() {
    }

    public boolean dateSupported() {
        return false;
    }

    public boolean booleanSupported() {
        return true;
    }

    public ExcelWorkbook openWorkbook(byte[] byArray, boolean bl) throws IOException {
        try {
            WorkBookHandle workBookHandle;
            WorkBookHandle workBookHandle2 = workBookHandle = byArray == null ? new WorkBookHandle() : new WorkBookHandle(byArray);
            if (workBookHandle.getWorkSheets() == null) {
                return null;
            }
            workBookHandle.setDupeStringMode(this._shareDupeStringCell ? WorkBookHandle.SHAREDUPES : WorkBookHandle.ALLOWDUPES);
            workBookHandle.setStringEncodingMode(WorkBookHandle.STRING_ENCODING_AUTO);
            return new ExcelWorkbookImpl(workBookHandle);
        }
        catch (WorkBookException workBookException) {
            if (workBookException.getErrorCode() == 0) {
                throw new ExcelUtil.DualStreamException();
            }
            throw new ExcelUtil.UnsupportedExcelFileException(workBookException.getLocalizedMessage());
        }
    }

    public ExcelWorkbook openWorkbook(String string, boolean bl) throws IOException {
        if (string == null) {
            return this.openWorkbook((byte[])null, bl);
        }
        File file = new File(string);
        if (!file.exists()) {
            return this.openWorkbook((byte[])null, bl);
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        byte[] byArray = new byte[(int)file.length()];
        if (bufferedInputStream.read(byArray) < byArray.length) {
            throw new IOException();
        }
        bufferedInputStream.close();
        return this.openWorkbook(byArray, bl);
    }

    private static class ExcelCellAttributesImpl
    extends ExcelCellAttributes {
        private FormatHandle _format;
        private FormulaHandle _formula;
        private ExcelColor _background;
        private ExcelColor _foreground;

        ExcelCellAttributesImpl(int n) {
            super(n);
        }

        void initFormatHandle(FormatHandle formatHandle) {
            int n;
            this._background = ExcelColor.getColor(formatHandle.getCellBackgroundColor());
            if (this._background == null) {
                this._background = ExcelColor.getWhiteColor();
            }
            if ((n = formatHandle.getFont().getFontColor()) == 0) {
                this._foreground = ExcelColor.getBlackColor();
            } else {
                this._foreground = ExcelColor.getColor(n);
                if (this._foreground == null) {
                    this._foreground = ExcelColor.getBlackColor();
                }
            }
            this._format = formatHandle;
        }

        void initFormulaHandle(FormulaHandle formulaHandle) {
            this._formula = formulaHandle;
        }

        public ExcelColor getBackgroundColor() {
            return this._background;
        }

        public String getComment() {
            return "";
        }

        public String getFontName() {
            return this._format.getFontName();
        }

        public int getFontSize() {
            return (int)this._format.getFontHeightInPoints();
        }

        public int getFontStyle() {
            int n = 0;
            if (this._format.getBold()) {
                ++n;
            }
            if (this._format.getItalic()) {
                n += 2;
            }
            return n;
        }

        public ExcelColor getForegroundColor() {
            return this._foreground;
        }

        public String getFormatPattern() {
            return this._format.getFormatPattern();
        }

        public String getFormula() {
            if (this._formula == null) {
                return null;
            }
            String string = this._formula.getFormulaString();
            if (string.startsWith("=")) {
                string = string.substring(1);
            }
            return string;
        }
    }

    private static class ExcelWorksheetImpl
    implements ExcelWorksheet {
        private ExcelWorkbookImpl _book;
        private WorkSheetHandle _sheet;
        private boolean _keepStringCell = true;
        private boolean _updateStringCell = false;
        private static final int BLANK_CELL = -1;
        private static final int STRING_CELL = 0;
        private static final int FLOAT_CELL = 1;
        private static final int INT_CELL = 2;
        private static final int FORMULA_CELL = 3;
        private static final int OBJECT_CELL = 5;

        ExcelWorksheetImpl(ExcelWorkbookImpl excelWorkbookImpl, WorkSheetHandle workSheetHandle) {
            this._book = excelWorkbookImpl;
            this._sheet = workSheetHandle;
        }

        public String getSheetName() {
            return this._sheet.getSheetName();
        }

        public Object getValue(String string) {
            Object object = null;
            try {
                long l;
                double d;
                CellHandle cellHandle = this._sheet.getCell(string);
                object = cellHandle.getVal();
                if (object instanceof Float) {
                    object = new Double(cellHandle.getDoubleVal());
                }
                try {
                    int n;
                    if (this._book.getRoundUpFormula() && cellHandle.getCellType() == 3 && !cellHandle.getFormulaHandle().evaluatesToString() && object instanceof String && (n = ((String)object).length()) > 15) {
                        int n2;
                        int n3;
                        String string2 = (String)object;
                        int n4 = string2.indexOf(101);
                        if (n4 != -1 || (n4 = string2.indexOf(69)) != -1) {
                            n = n4;
                        }
                        if ((n3 = string2.indexOf(46)) != -1 && (n4 == -1 || n3 < n4)) {
                            --n;
                        }
                        if ((n2 = string2.indexOf(45)) != -1 && (n4 == -1 || n2 < n4)) {
                            --n;
                        }
                        if (n > 15) {
                            Double d2 = ExcelUtil.round16(cellHandle.getDoubleVal());
                            object = d2 == (double)d2.longValue() ? String.valueOf(d2.longValue()) : d2.toString();
                        }
                    }
                }
                catch (FormulaNotFoundException formulaNotFoundException) {
                    // empty catch block
                }
                if (object instanceof Double && (d = ((Double)object).doubleValue()) == (double)(l = ((Double)object).longValue())) {
                    object = new Long(l);
                }
            }
            catch (CellNotFoundException cellNotFoundException) {
                // empty catch block
            }
            return object;
        }

        public boolean setValue(String string, Object object, ExcelCellAttributes excelCellAttributes) {
            Object object2;
            CellHandle cellHandle;
            int n;
            FormatHandle formatHandle;
            block28: {
                formatHandle = null;
                n = 0;
                cellHandle = null;
                try {
                    object2 = null;
                    cellHandle = this._sheet.getCell(string);
                    int n2 = cellHandle.getCellType();
                    if (object instanceof String && ((String)object).length() == 0 && excelCellAttributes == null) {
                        object2 = cellHandle.getVal();
                        if (object2 instanceof String && ((String)object2).length() == 0) {
                            return true;
                        }
                    } else if (n2 == 0) {
                        object2 = cellHandle.getVal();
                    }
                    if (n2 == 2 && object instanceof Long) {
                        object = (Long)object == (long)((Long)object).intValue() ? (Number)new Integer(((Long)object).intValue()) : (Number)new Double(((Long)object).doubleValue());
                    }
                    n = cellHandle.getFormatId();
                    if (excelCellAttributes != null && excelCellAttributes.hasCellFormat()) {
                        formatHandle = new FormatHandle(cellHandle);
                        this.updateFormatHandle(formatHandle, excelCellAttributes);
                        formatHandle.pack();
                    }
                    if ((!this._updateStringCell || n2 != 0 || !(object instanceof String)) && ((!this._keepStringCell || n2 != -1) && object instanceof String || n2 != -1 && n2 != 1 && n2 != 5 && (object instanceof Double || object instanceof Float) || n2 != -1 && n2 != 2 && (object instanceof Integer || object instanceof Long))) {
                        this.clearValue(string, false);
                        cellHandle = null;
                    }
                    if (cellHandle == null) break block28;
                    cellHandle.setVal(object);
                    if (excelCellAttributes != null && excelCellAttributes.hasFormula()) {
                        try {
                            String string2 = excelCellAttributes.getFormula();
                            if (!string2.startsWith("=")) {
                                string2 = "=" + string2;
                            }
                            cellHandle.setFormula(string2);
                        }
                        catch (Exception exception) {
                            return false;
                        }
                    }
                    if (formatHandle != null) {
                        cellHandle.setFormatHandle(formatHandle);
                    } else if (excelCellAttributes != null && excelCellAttributes.hasFormula()) {
                        cellHandle.setFormatId(n);
                    }
                }
                catch (CellNotFoundException cellNotFoundException) {
                    cellHandle = null;
                }
                catch (CellTypeMismatchException cellTypeMismatchException) {
                    this.clearValue(string, false);
                    cellHandle = null;
                }
            }
            if (cellHandle == null) {
                this._sheet.add(object, string);
                if (n > 0 || excelCellAttributes != null && (excelCellAttributes.hasCellFormat() || excelCellAttributes.hasFormula())) {
                    try {
                        cellHandle = this._sheet.getCell(string);
                        if (excelCellAttributes != null && excelCellAttributes.hasFormula()) {
                            try {
                                object2 = excelCellAttributes.getFormula();
                                if (!((String)object2).startsWith("=")) {
                                    object2 = "=" + (String)object2;
                                }
                                cellHandle.setFormula((String)object2);
                            }
                            catch (Exception exception) {
                                return false;
                            }
                        }
                        if (excelCellAttributes == null || !excelCellAttributes.hasCellFormat()) {
                            cellHandle.setFormatId(n);
                        } else {
                            if (formatHandle == null) {
                                formatHandle = new FormatHandle((WorkBook)this._book._book);
                            }
                            this.updateFormatHandle(formatHandle, excelCellAttributes);
                            formatHandle.pack();
                            cellHandle.setFormatHandle(formatHandle);
                        }
                    }
                    catch (CellNotFoundException cellNotFoundException) {
                        // empty catch block
                    }
                }
            }
            return true;
        }

        private void updateFormatHandle(FormatHandle formatHandle, ExcelCellAttributes excelCellAttributes) {
            if (excelCellAttributes.hasBackgroundColor()) {
                formatHandle.setCellBackgroundColor(excelCellAttributes.getBackgroundColor().getIndex());
            }
            if (excelCellAttributes.hasForegroundColor()) {
                formatHandle.setFontColor(excelCellAttributes.getForegroundColor().getIndex());
            }
            if (excelCellAttributes.hasFontName()) {
                formatHandle.setFontName(excelCellAttributes.getFontName());
            }
            if (excelCellAttributes.hasFontSize()) {
                formatHandle.setFontHeight(excelCellAttributes.getFontSize() * 20);
            }
            if (excelCellAttributes.hasFontStyle()) {
                int n = excelCellAttributes.getFontStyle();
                formatHandle.setBold((n & 1) != 0);
                formatHandle.setItalic((n & 2) != 0);
            }
            if (excelCellAttributes.hasFormatPattern()) {
                formatHandle.setFormatPattern(excelCellAttributes.getFormatPattern());
            } else if (formatHandle.getFormatPattern() == null) {
                formatHandle.setFormatPattern("General");
            }
        }

        public boolean clearValue(String string) {
            return this.clearValue(string, true);
        }

        private boolean clearValue(String string, boolean bl) {
            CellHandle cellHandle;
            int n = 0;
            try {
                cellHandle = this._sheet.getCell(string);
                if (bl) {
                    Object object = cellHandle.getVal();
                    if (object instanceof String && ((String)object).length() == 0) {
                        return true;
                    }
                    n = cellHandle.getFormatId();
                }
                this._sheet.removeCell(string);
            }
            catch (CellNotFoundException cellNotFoundException) {
                // empty catch block
            }
            if (n > 0) {
                this._sheet.add((Object)"", string);
                try {
                    cellHandle = this._sheet.getCell(string);
                    cellHandle.setFormatId(n);
                }
                catch (CellNotFoundException cellNotFoundException) {
                    // empty catch block
                }
            }
            return true;
        }

        public ExcelCellAttributes getAttrbutes(String string, int n) {
            CellHandle cellHandle = null;
            try {
                cellHandle = this._sheet.getCell(string);
            }
            catch (CellNotFoundException cellNotFoundException) {
                // empty catch block
            }
            if (cellHandle == null) {
                return null;
            }
            ExcelCellAttributesImpl excelCellAttributesImpl = new ExcelCellAttributesImpl(n);
            if (excelCellAttributesImpl.hasCellFormat()) {
                excelCellAttributesImpl.initFormatHandle(cellHandle.getFormatHandle());
            }
            if (excelCellAttributesImpl.hasFormula()) {
                try {
                    excelCellAttributesImpl.initFormulaHandle(cellHandle.getFormulaHandle());
                }
                catch (FormulaNotFoundException formulaNotFoundException) {
                    // empty catch block
                }
            }
            return excelCellAttributesImpl;
        }
    }

    private static class ExcelWorkbookImpl
    implements ExcelWorkbook {
        private WorkBookHandle _book;
        private boolean _roundUpForumla = false;

        ExcelWorkbookImpl(WorkBookHandle workBookHandle) {
            this._book = workBookHandle;
        }

        public void setAutoCalculation(boolean bl) {
            this._book.setFormulaCalculationMode(bl ? WorkBookHandle.CALCULATE_ALWAYS : WorkBookHandle.CALCULATE_EXPLICIT);
        }

        public void setRoundUpFormula(boolean bl) {
            this._roundUpForumla = bl;
        }

        public boolean getRoundUpFormula() {
            return this._roundUpForumla;
        }

        public byte[] close(String string, boolean bl, boolean bl2) throws IOException {
            if (bl || bl2) {
                byte[] byArray = this._book.getBytes();
                if (bl) {
                    File file = new File(string);
                    File file2 = file.getParentFile();
                    if (!file2.exists() && !file2.mkdirs()) {
                        throw new IOException("cannot create directory," + file2.getAbsolutePath());
                    }
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                    bufferedOutputStream.write(byArray);
                    bufferedOutputStream.close();
                }
                return byArray;
            }
            return new byte[0];
        }

        public ExcelWorksheet getWorksheet(String string) {
            try {
                return new ExcelWorksheetImpl(this, this._book.getWorkSheet(string));
            }
            catch (WorkSheetNotFoundException workSheetNotFoundException) {
                return null;
            }
        }

        public ExcelWorksheet createWorksheet(String string) {
            return new ExcelWorksheetImpl(this, this._book.createWorkSheet(string));
        }

        public ExcelWorksheet copyWorksheet(String string, String string2) {
            try {
                return new ExcelWorksheetImpl(this, this._book.copyWorkSheet(string, string2));
            }
            catch (WorkSheetNotFoundException workSheetNotFoundException) {
                return null;
            }
        }
    }
}

