/*
 * Decompiled with CFR 0.152.
 */
package com.infoteria.asteria.flowlibrary2.component.format;

import com.infoteria.asteria.flowlibrary2.FlowException;
import com.infoteria.asteria.flowlibrary2.component.format.ExcelCellAttributes;
import com.infoteria.asteria.flowlibrary2.component.format.ExcelColor;
import com.infoteria.asteria.flowlibrary2.component.format.ExcelUtilExtenXLS;
import com.infoteria.asteria.flowlibrary2.component.format.ExcelUtilJExcelApi;
import com.infoteria.asteria.flowlibrary2.component.format.ExcelUtilJNIWrapper;
import com.infoteria.asteria.flowlibrary2.component.format.ExcelWorkbook;
import com.infoteria.asteria.value.FlowDateFormat;
import com.infoteria.asteria.value.Value;
import com.infoteria.asteria.value.ValueConvertException;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public abstract class ExcelUtil {
    public static final int EXTEN_XLS = 0;
    public static final int JNI_WRAPPER = 1;
    public static final int JEXCEL_API = 2;
    private static ThreadLocal _extenXls = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return null;
        }
    };
    private static ThreadLocal _jniWrapper = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return null;
        }
    };
    private static ThreadLocal _jxl = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return null;
        }
    };
    private static DecimalFormat format17 = new DecimalFormat("0.0000000000000000E0");

    public static ExcelUtil getInstance(int n) {
        ExcelUtil excelUtil;
        if (n == 2) {
            excelUtil = (ExcelUtil)_jxl.get();
            if (excelUtil == null) {
                excelUtil = new ExcelUtilJExcelApi();
                _jxl.set(excelUtil);
            }
        } else if (n == 1) {
            excelUtil = (ExcelUtil)_jniWrapper.get();
            if (excelUtil == null) {
                excelUtil = new ExcelUtilJNIWrapper();
                _jniWrapper.set(excelUtil);
            }
        } else {
            excelUtil = (ExcelUtil)_extenXls.get();
            if (excelUtil == null) {
                excelUtil = new ExcelUtilExtenXLS();
                _extenXls.set(excelUtil);
            }
        }
        return excelUtil;
    }

    public static Value cellToValue(Object object, Value.Type type, Calendar calendar) throws ValueConvertException {
        Object object2 = object;
        if (object2 == null) {
            object2 = "";
        }
        if (type == Value.TYPE_DATETIME) {
            if (object2 instanceof Date) {
                return new Value((Date)object2);
            }
            double d = 0.0;
            if (object2 instanceof Number) {
                d = ((Number)object2).doubleValue();
            } else if (object2 instanceof String) {
                try {
                    d = Double.valueOf((String)object2);
                }
                catch (NumberFormatException numberFormatException) {
                    return new Value(type);
                }
            } else {
                return new Value(type);
            }
            return new Value(ExcelUtil.doubleToDate(d, calendar));
        }
        if (type == Value.TYPE_INTEGER) {
            if (object2 instanceof Long) {
                return new Value((Long)object2);
            }
            if (object2 instanceof Number) {
                return new Value(((Number)object2).longValue());
            }
            if (object2 instanceof String) {
                try {
                    return new Value(type, (String)object2);
                }
                catch (ValueConvertException valueConvertException) {
                    try {
                        return new Value(Double.valueOf((String)object2).longValue());
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ValueConvertException((Exception)numberFormatException, type, object2);
                    }
                }
            }
            if (object2 instanceof Boolean) {
                return new Value((Boolean)object2 != false ? 1 : 0);
            }
            if (object2 instanceof Date) {
                return new Value((long)ExcelUtil.dateToDouble((Date)object2, calendar));
            }
        } else if (type == Value.TYPE_BOOLEAN) {
            if (object2 instanceof Boolean) {
                return new Value((Boolean)object2);
            }
            if (object2 instanceof Number) {
                return new Value(((Number)object2).longValue() != 0L);
            }
            if (object2 instanceof String) {
                return new Value(type, (String)object2);
            }
            if (object2 instanceof Date) {
                return new Value(false);
            }
        } else if (type == Value.TYPE_DECIMAL) {
            if (object2 instanceof Number) {
                return new Value(new BigDecimal(object2.toString()));
            }
            if (object2 instanceof String) {
                return new Value(type, (String)object2);
            }
            if (object2 instanceof Boolean) {
                return new Value(new BigDecimal((Boolean)object2 != false ? 1 : 0));
            }
            if (object2 instanceof Date) {
                return new Value(new BigDecimal(String.valueOf(ExcelUtil.dateToDouble((Date)object2, calendar))));
            }
        } else if (type == Value.TYPE_DOUBLE) {
            if (object2 instanceof Number) {
                return new Value(((Number)object2).doubleValue());
            }
            if (object2 instanceof String) {
                return new Value(type, (String)object2);
            }
            if (object2 instanceof Boolean) {
                return new Value(new BigDecimal((Boolean)object2 != false ? 1.0 : 0.0));
            }
            if (object2 instanceof Date) {
                return new Value(ExcelUtil.dateToDouble((Date)object2, calendar));
            }
        } else if (type == Value.TYPE_STRING) {
            if (object2 instanceof String) {
                return new Value((String)object2);
            }
            if (object2 instanceof Date) {
                return new Value(FlowDateFormat.getThreadInstance().format((Date)object2));
            }
            return new Value(object2.toString());
        }
        return new Value(type);
    }

    public static double dateToDouble(Date date, Calendar calendar) {
        double d = date.getTime() + (long)calendar.getTimeZone().getRawOffset();
        d /= 8.64E7;
        return d += 25569.0;
    }

    public static Date doubleToDate(double d, Calendar calendar) {
        calendar.clear();
        calendar.set(1899, 11, 31);
        int n = (int)Math.floor(d);
        if (n != 0) {
            calendar.add(5, n >= 61 ? n - 1 : n);
        }
        if (d != (double)n) {
            calendar.add(14, (int)Math.floor((d -= (double)n) * 8.64E7 + 0.5));
        }
        return calendar.getTime();
    }

    public static Double round16(double d) {
        int n = d < 0.0 ? 1 : 0;
        String string = format17.format(d);
        BigDecimal bigDecimal = new BigDecimal(string.substring(0, n + 18));
        return Double.valueOf(bigDecimal.setScale(14, 4).toString() + string.substring(n + 18));
    }

    public static int getCellAttrCount(int n) {
        int n2 = 0;
        if ((n & 1) != 0) {
            ++n2;
        }
        if ((n & 2) != 0) {
            ++n2;
        }
        if ((n & 4) != 0) {
            ++n2;
        }
        if ((n & 8) != 0) {
            ++n2;
        }
        if ((n & 0x10) != 0) {
            ++n2;
        }
        if ((n & 0x20) != 0) {
            ++n2;
        }
        if ((n & 0x40) != 0) {
            ++n2;
        }
        if ((n & 0x80) != 0) {
            ++n2;
        }
        return n2;
    }

    public static String[] getCellAttrSuffix(int n, String[] stringArray) {
        int n2 = 0;
        if ((n & 1) != 0) {
            stringArray[n2++] = "_Background";
        }
        if ((n & 2) != 0) {
            stringArray[n2++] = "_FontColor";
        }
        if ((n & 4) != 0) {
            stringArray[n2++] = "_FontName";
        }
        if ((n & 8) != 0) {
            stringArray[n2++] = "_FontSize";
        }
        if ((n & 0x10) != 0) {
            stringArray[n2++] = "_FontStyle";
        }
        if ((n & 0x20) != 0) {
            stringArray[n2++] = "_Format";
        }
        if ((n & 0x40) != 0) {
            stringArray[n2++] = "_Formula";
        }
        if ((n & 0x80) != 0) {
            stringArray[n2++] = "_Comment";
        }
        return stringArray;
    }

    public static Value[] getCellAttrValues(ExcelCellAttributes excelCellAttributes, Value[] valueArray, int n) {
        int n2 = n;
        if (excelCellAttributes.hasBackgroundColor()) {
            valueArray[n2++] = new Value(excelCellAttributes.getBackgroundColor().getName());
        }
        if (excelCellAttributes.hasForegroundColor()) {
            valueArray[n2++] = new Value(excelCellAttributes.getForegroundColor().getName());
        }
        if (excelCellAttributes.hasFontName()) {
            valueArray[n2++] = new Value(excelCellAttributes.getFontName());
        }
        if (excelCellAttributes.hasFontSize()) {
            valueArray[n2++] = new Value(excelCellAttributes.getFontSize());
        }
        if (excelCellAttributes.hasFontStyle()) {
            valueArray[n2++] = new Value(excelCellAttributes.getFontStyle());
        }
        if (excelCellAttributes.hasFormatPattern()) {
            valueArray[n2++] = new Value(excelCellAttributes.getFormatPattern());
        }
        if (excelCellAttributes.hasFormula()) {
            valueArray[n2++] = new Value(excelCellAttributes.getFormula());
        }
        if (excelCellAttributes.hasComment()) {
            valueArray[n2++] = new Value(excelCellAttributes.getComment());
        }
        return valueArray;
    }

    public ExcelCellAttributes getCellAttributes(int n, Value[] valueArray, List list) {
        ExcelColor excelColor;
        String string;
        ExcelCellAttributes excelCellAttributes = new ExcelCellAttributes(n);
        int n2 = 0;
        if (excelCellAttributes.hasBackgroundColor()) {
            if (valueArray[n2].isNull()) {
                excelCellAttributes.unsetBackgroundColor();
            } else {
                string = valueArray[n2].strValue();
                excelColor = ExcelColor.getColor(string);
                if (excelColor == null) {
                    list.add(string);
                    excelColor = ExcelColor.getWhiteColor();
                }
                excelCellAttributes.setBackgroundColor(excelColor);
            }
            ++n2;
        }
        if (excelCellAttributes.hasForegroundColor()) {
            if (valueArray[n2].isNull()) {
                excelCellAttributes.unsetForegroundColor();
            } else {
                string = valueArray[n2].strValue();
                excelColor = ExcelColor.getColor(string);
                if (excelColor == null) {
                    list.add(string);
                    excelColor = ExcelColor.getBlackColor();
                }
                excelCellAttributes.setForegroundColor(excelColor);
            }
            ++n2;
        }
        if (excelCellAttributes.hasFontName()) {
            if (valueArray[n2].isNull()) {
                excelCellAttributes.unsetFontName();
            } else {
                excelCellAttributes.setFontName(valueArray[n2].strValue());
            }
            ++n2;
        }
        if (excelCellAttributes.hasFontSize()) {
            if (valueArray[n2].isNull()) {
                excelCellAttributes.unsetFontSize();
            } else {
                excelCellAttributes.setFontSize(valueArray[n2].intValue());
            }
            ++n2;
        }
        if (excelCellAttributes.hasFontStyle()) {
            if (valueArray[n2].isNull()) {
                excelCellAttributes.unsetFontStyle();
            } else {
                excelCellAttributes.setFontStyle(valueArray[n2].intValue());
            }
            ++n2;
        }
        if (excelCellAttributes.hasFormatPattern()) {
            if (valueArray[n2].isNull()) {
                excelCellAttributes.unsetFormatPattern();
            } else {
                excelCellAttributes.setFormatPattern(valueArray[n2].strValue());
            }
            ++n2;
        }
        if (excelCellAttributes.hasFormula()) {
            if (valueArray[n2].isNull()) {
                excelCellAttributes.unsetFormula();
            } else {
                excelCellAttributes.setFormula(valueArray[n2].strValue());
            }
            ++n2;
        }
        if (excelCellAttributes.hasComment()) {
            if (valueArray[n2].isNull()) {
                excelCellAttributes.unsetComment();
            } else {
                excelCellAttributes.setComment(valueArray[n2].strValue());
            }
            ++n2;
        }
        return excelCellAttributes;
    }

    public abstract boolean initialize() throws FlowException;

    public abstract void terminate();

    public abstract boolean booleanSupported();

    public abstract boolean dateSupported();

    public abstract ExcelWorkbook openWorkbook(byte[] var1, boolean var2) throws IOException;

    public abstract ExcelWorkbook openWorkbook(String var1, boolean var2) throws IOException;

    public static class WriteException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public WriteException() {
        }

        public WriteException(String string) {
            super(string);
        }
    }

    public static class DualStreamException
    extends UnsupportedExcelFileException {
        private static final long serialVersionUID = 1L;

        public DualStreamException() {
        }

        public DualStreamException(String string) {
            super(string);
        }
    }

    public static class UnsupportedExcelFileException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public UnsupportedExcelFileException() {
        }

        public UnsupportedExcelFileException(String string) {
            super(string);
        }
    }
}

