/*
 * Decompiled with CFR 0.152.
 */
package com.infoteria.asteria.flowlibrary2.component.format;

import com.infoteria.asteria.flowengine2.execute.ExecuteContext;
import com.infoteria.asteria.flowengine2.flow.Component;
import com.infoteria.asteria.flowengine2.flow.ComponentCompiler;
import com.infoteria.asteria.flowengine2.flow.ComponentEntrance;
import com.infoteria.asteria.flowengine2.flow.InputConnector;
import com.infoteria.asteria.flowlibrary2.FlowException;
import com.infoteria.asteria.flowlibrary2.component.SimpleComponent;
import com.infoteria.asteria.flowlibrary2.component.format.ExcelCellAttributes;
import com.infoteria.asteria.flowlibrary2.component.format.ExcelCellMapping;
import com.infoteria.asteria.flowlibrary2.component.format.ExcelFieldMapping;
import com.infoteria.asteria.flowlibrary2.component.format.ExcelLicenseManager;
import com.infoteria.asteria.flowlibrary2.component.format.ExcelMapping;
import com.infoteria.asteria.flowlibrary2.component.format.ExcelMappingCompiler;
import com.infoteria.asteria.flowlibrary2.component.format.ExcelMappingProperty;
import com.infoteria.asteria.flowlibrary2.component.format.ExcelRecordMapping;
import com.infoteria.asteria.flowlibrary2.component.format.ExcelUtil;
import com.infoteria.asteria.flowlibrary2.component.format.ExcelWorkbook;
import com.infoteria.asteria.flowlibrary2.component.format.ExcelWorksheet;
import com.infoteria.asteria.flowlibrary2.property.BooleanProperty;
import com.infoteria.asteria.flowlibrary2.property.EnumProperty;
import com.infoteria.asteria.flowlibrary2.property.ExtendedCategoryProperty;
import com.infoteria.asteria.flowlibrary2.property.PathResolverProperty;
import com.infoteria.asteria.flowlibrary2.property.Property;
import com.infoteria.asteria.flowlibrary2.property.PropertyException;
import com.infoteria.asteria.flowlibrary2.property.SimpleCategoryProperty;
import com.infoteria.asteria.flowlibrary2.property.StringProperty;
import com.infoteria.asteria.flowlibrary2.stream.Record;
import com.infoteria.asteria.flowlibrary2.stream.StreamDataObject;
import com.infoteria.asteria.flowlibrary2.stream.StreamException;
import com.infoteria.asteria.value.Value;
import com.infoteria.asteria.value.ValueConvertException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ExcelOutputComponent
extends SimpleComponent {
    public static final String COMPONENT_NAME = "Excel(Output)";
    public static final String M_FAIL_TO_CREATE_SHEET = "202";
    public static final String M_NO_CHANGES = "203";
    public static final String M_RECORD_OVERFLOW = "204";
    public static final String M_NO_SUCH_RECORD = "205";
    public static final String M_FAIL_TO_WRITE_CELL = "206";
    public static final String M_FAIL_TO_MOVE_CELL = "207";
    public static final String M_FAIL_TO_REMOVE_CELL = "208";
    public static final String M_ERROR_IN_EXTERNAL_LIBRARY = "209";
    public static final String M_UNSUPPORTED_XLS = "210";
    public static final String M_DUAL_STREAM_UNSUPPORTED = "211";
    public static final String M_INVALID_CELL_ATTR = "212";
    private static final String S_MODE_OVERRIDE = "Override";
    private static final String S_MODE_OVERRIDE_NON_CLEAR = "OverrideNonClear";
    private static final String S_MODE_APPEND = "Append";
    private static final String S_MODE_INSERT = "Insert";
    private static final String S_MODE_UPDATE = "Update";
    private static final String S_MODE_DELETE = "Delete";
    private static final String P_OUTPUT_SHEET_CREATE_MODE = "OutputSheetCreateMode";
    private static final String COLUMN_OUTPUT_SHEET_CREATE_MODE = "Mode";
    private static final String S_CREATE_MODE_NEW = "New";
    private static final String S_CREATE_MODE_COPY = "Copy";
    private static final String S_CONVERT_NULL_TO_ZERO = "Zero";
    private static final String S_CONVERT_NULL_TO_EMPTY = "Empty";
    protected static final String S_LIBRARY_EXTEN_XLS = "MultiPlatform";
    protected static final String S_LIBRARY_JNI_WRAPPER = "NativeExcel";
    protected static final String S_LIBRARY_JEXCEL_API = "MultiPlatform(Light)";
    protected static final String S_LIBRARY_JEXCEL_API2 = "MultiPlatform(Fast)";
    private static final int MODE_OVERRIDE = 0;
    private static final int MODE_APPEND = 1;
    private static final int MODE_INSERT = 2;
    private static final int MODE_UPDATE = 3;
    private static final int MODE_DELETE = 4;
    private static final int MODE_OVERRIDE_NON_CLEAR = 5;
    protected EnumProperty _externalLibrary = new EnumProperty("ExternalLibrary", false, false, "MultiPlatform");
    private EnumProperty _outputMode = new EnumProperty("Mode", false, true, "Override");
    private BooleanProperty _updateFile = new BooleanProperty("UpdateFile", false, true, true);
    private StringProperty _outputFilePath = new StringProperty("FilePath", false, true, null);
    private BooleanProperty _allowBlankRecord = new BooleanProperty("AllowBlankRecord", false, true, true);
    private StringProperty _outputSheetNameProperty = new StringProperty("OutputSheetName", false, true, null);
    private ExtendedCategoryProperty _outputSheetNamesProperty = new ExtendedCategoryProperty("Sheet");
    private EnumProperty _outputSheetCreateMode = new EnumProperty("OutputSheetCreateMode", false, true, "New");
    private EnumProperty _convertNullMode = new EnumProperty("ConvertNull", false, true, "Zero");
    private SimpleCategoryProperty _cellProperty = new SimpleCategoryProperty("Cell");
    private ExcelMappingProperty _mappingProperty = new ExcelMappingProperty("EMF");
    private StringProperty _templateProperty = new StringProperty("Template");
    private PathResolverProperty _homeMode = new PathResolverProperty("HomeDirectory", "Relative");
    private BooleanProperty _autoCalculation = new BooleanProperty("AutoCalculation", false, true, false);
    private BooleanProperty _roundUpFormula = new BooleanProperty("RoundUpFormula", false, true, false);
    private BooleanProperty _scenarioModeProperty = new BooleanProperty("ScenarioMode", false, true, false);
    private static final int SCENARIO_NONE = 0;
    private static final int SCENARIO_ONLY = 1;
    private static final int SCENARIO_OUT = 2;
    private int _scenarioMode = 0;
    private PrintStream _scenarioStream = null;
    private boolean _convertNullToZero = true;
    private String _filePath;
    private Value[] _cellValues;
    private ExcelCellAttributes[] _cellAttrs;
    private ArrayList[] _records;
    private ArrayList[] _recordAttrs;
    private Calendar _calendar = Calendar.getInstance();
    private ExcelUtil _excelUtil;
    private ExecuteContext _executeContext;

    public String getComponentName() {
        return COMPONENT_NAME;
    }

    public String getLicenseStr() {
        return ExcelLicenseManager.getLicenseStr();
    }

    private static boolean isBlankRecord(ExcelWorksheet excelWorksheet, ExcelRecordMapping excelRecordMapping, int n, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < excelRecordMapping.getFieldCount(); ++i) {
            ExcelFieldMapping excelFieldMapping = excelRecordMapping.getFieldMapping(i);
            stringBuilder.setLength(0);
            stringBuilder.append(excelFieldMapping.getColumn()).append(n + excelFieldMapping.getRow());
            Object object = excelWorksheet.getValue(stringBuilder.toString());
            if (object == null || !bl && object instanceof String && ((String)object).length() == 0) continue;
            return false;
        }
        return true;
    }

    public ExcelOutputComponent() {
        this.getInputConnector().setAcceptType(112);
        this.getOutputConnector().setAcceptType(1);
        this._outputMode.addEnumeration(S_MODE_OVERRIDE);
        this._outputMode.addEnumeration(S_MODE_OVERRIDE_NON_CLEAR);
        this._outputMode.addEnumeration(S_MODE_APPEND);
        this._outputMode.addEnumeration(S_MODE_INSERT);
        this._outputMode.addEnumeration(S_MODE_UPDATE);
        this._outputMode.addEnumeration(S_MODE_DELETE);
        this.registProperty((Property)this._outputFilePath);
        this.registProperty((Property)this._updateFile);
        this.registProperty((Property)this._allowBlankRecord);
        this.registProperty((Property)this._outputMode);
        this.registProperty((Property)this._outputSheetNameProperty);
        this._outputSheetCreateMode.addEnumeration(S_CREATE_MODE_NEW);
        this._outputSheetCreateMode.addEnumeration(S_CREATE_MODE_COPY);
        this.registProperty((Property)this._outputSheetNamesProperty);
        this.registProperty((Property)this._outputSheetCreateMode);
        this._convertNullMode.addEnumeration(S_CONVERT_NULL_TO_ZERO);
        this._convertNullMode.addEnumeration(S_CONVERT_NULL_TO_EMPTY);
        this.registProperty((Property)this._convertNullMode);
        this.registProperty((Property)this._cellProperty);
        this.registProperty(this._mappingProperty);
        this.registProperty((Property)this._templateProperty);
        this.registProperty((Property)this._homeMode);
        this._externalLibrary.addEnumeration(S_LIBRARY_EXTEN_XLS);
        this._externalLibrary.addEnumeration(S_LIBRARY_JNI_WRAPPER);
        this._externalLibrary.addEnumeration(S_LIBRARY_JEXCEL_API);
        this._externalLibrary.addEnumeration(S_LIBRARY_JEXCEL_API2);
        this.registProperty((Property)this._externalLibrary);
        this.registProperty((Property)new ExcelMappingCompiler.KeyedCategoryProperty("Field(Input)"));
        this.registProperty((Property)this._autoCalculation);
        this.registProperty((Property)this._roundUpFormula);
        this.registProperty((Property)this._scenarioModeProperty);
    }

    private void readRecord(int n) throws StreamException {
        int n2;
        ArrayList arrayList = new ArrayList();
        ExcelMapping excelMapping = this._mappingProperty.getMapping();
        ComponentEntrance componentEntrance = this.getComponentEntrance();
        for (n2 = 0; n2 < this._records.length; ++n2) {
            Record record;
            ExcelRecordMapping excelRecordMapping = excelMapping.getRecordMapping(n2);
            InputConnector inputConnector = n2 == 0 ? componentEntrance.getDefaultConnector() : componentEntrance.getSubConnector(excelRecordMapping.getConnectorName());
            this._records[n2].clear();
            this._recordAttrs[n2].clear();
            StreamDataObject streamDataObject = inputConnector.getStream();
            if (streamDataObject == null || (record = streamDataObject.getRecord()) == null || !record.first()) continue;
            do {
                Value[] valueArray = new Value[excelRecordMapping.getFieldCount()];
                ExcelCellAttributes[] excelCellAttributesArray = new ExcelCellAttributes[excelRecordMapping.getFieldCount()];
                for (int i = 0; i < excelRecordMapping.getFieldCount(); ++i) {
                    ExcelFieldMapping excelFieldMapping = excelRecordMapping.getFieldMapping(i);
                    valueArray[i] = record.getValue(excelFieldMapping.getName());
                    if (excelFieldMapping.getAttrCount() <= 0) continue;
                    String[] stringArray = excelFieldMapping.getAttrSuffix();
                    Value[] valueArray2 = new Value[excelFieldMapping.getAttrCount()];
                    for (int j = 0; j < stringArray.length; ++j) {
                        valueArray2[j] = record.getValue(excelFieldMapping.getName() + stringArray[j]);
                    }
                    excelCellAttributesArray[i] = this._excelUtil.getCellAttributes(excelFieldMapping.getAttrMask(), valueArray2, arrayList);
                }
                this._records[n2].add(valueArray);
                this._recordAttrs[n2].add(excelCellAttributesArray);
            } while (record.next());
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            this._executeContext.warn(this.getMessage(M_INVALID_CELL_ATTR, arrayList.get(n2)));
        }
    }

    private void readCells() {
        int n;
        ArrayList arrayList = new ArrayList();
        ExcelMapping excelMapping = this._mappingProperty.getMapping();
        this._cellValues = new Value[excelMapping.getCellCount()];
        this._cellAttrs = new ExcelCellAttributes[excelMapping.getCellCount()];
        for (n = 0; n < excelMapping.getCellCount(); ++n) {
            ExcelCellMapping excelCellMapping = excelMapping.getCellMapping(n);
            this._cellValues[n] = this._cellProperty.getValue(excelCellMapping.getName());
            if (excelCellMapping.getAttrCount() <= 0) continue;
            String[] stringArray = excelCellMapping.getAttrSuffix();
            Value[] valueArray = new Value[excelCellMapping.getAttrCount()];
            for (int i = 0; i < stringArray.length; ++i) {
                valueArray[i] = this._cellProperty.getValue(excelCellMapping.getName() + stringArray[i]);
            }
            this._cellAttrs[n] = this._excelUtil.getCellAttributes(excelCellMapping.getAttrMask(), valueArray, arrayList);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            this._executeContext.warn(this.getMessage(M_INVALID_CELL_ATTR, arrayList.get(n)));
        }
    }

    private byte[] writeWorkBook(String string, int n) throws PropertyException, FlowException {
        byte[] byArray;
        Object object;
        Object object2;
        Object object3;
        int n2;
        ExcelWorkbook excelWorkbook;
        ExcelMapping excelMapping = this._mappingProperty.getMapping();
        int n3 = excelMapping.getCellCount();
        for (int i = 0; i < excelMapping.getRecordCount(); ++i) {
            n3 += excelMapping.getRecordMapping(i).getFieldCount();
        }
        if (n3 == 0) {
            File file;
            this._executeContext.warn(this.getMessage(M_NO_CHANGES));
            byte[] byArray2 = null;
            if (string != null && (file = new File(string)).exists()) {
                try {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                    byArray2 = new byte[(int)file.length()];
                    if (bufferedInputStream.read(byArray2) < byArray2.length) {
                        byArray2 = null;
                    }
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {
                    byArray2 = null;
                }
                if (byArray2 == null) {
                    throw new FlowException("Cannot read file, " + string);
                }
            }
            return byArray2;
        }
        try {
            excelWorkbook = this._excelUtil.openWorkbook(string, false);
            if (excelWorkbook == null) {
                throw new FlowException(this.getMessage(M_UNSUPPORTED_XLS, string));
            }
            excelWorkbook.setAutoCalculation(this._autoCalculation.booleanValue());
            excelWorkbook.setRoundUpFormula(this._roundUpFormula.booleanValue());
        }
        catch (ExcelUtil.DualStreamException dualStreamException) {
            throw new FlowException(this.getMessage(M_DUAL_STREAM_UNSUPPORTED, string));
        }
        catch (ExcelUtil.UnsupportedExcelFileException unsupportedExcelFileException) {
            throw new FlowException(this.getMessage(M_UNSUPPORTED_XLS, string));
        }
        catch (IOException iOException) {
            throw new FlowException("Cannot read file, " + string);
        }
        String string2 = null;
        if (this._outputSheetNameProperty.getValue() != null && this._outputSheetNameProperty.strValue().length() != 0) {
            string2 = this._outputSheetNameProperty.strValue();
        }
        boolean bl = S_CREATE_MODE_COPY.equals(this._outputSheetCreateMode.strValue());
        HashMap<Object, Value> hashMap = new HashMap<Object, Value>();
        for (n2 = 0; n2 < excelMapping.getRecordCount() + excelMapping.getCellCount(); ++n2) {
            Object object4;
            Object object5 = object3 = n2 < excelMapping.getRecordCount() ? excelMapping.getRecordMapping(n2) : excelMapping.getCellMapping(n2 - excelMapping.getRecordCount());
            if (object3 == null || hashMap.containsKey(object2 = ((ExcelCellMapping)object3).getSheetName())) continue;
            if (string2 != null) {
                object = string2;
                string2 = null;
            } else {
                object4 = this._outputSheetNamesProperty.getValue((String)object2);
                if (object4 != null && !object4.isNull() && object4.strValue().length() != 0) {
                    object = object4.strValue();
                    Map map = this._outputSheetNamesProperty.getAttributeMap((String)object2);
                    bl = map != null && S_CREATE_MODE_COPY.equals(map.get(COLUMN_OUTPUT_SHEET_CREATE_MODE));
                } else {
                    object = object2;
                    bl = false;
                }
            }
            object4 = excelWorkbook.getWorksheet((String)object);
            if (object4 == null) {
                if (!bl) {
                    if (this._scenarioMode != 0) {
                        this._scenarioStream.println("create worksheet " + (String)object);
                    }
                    excelWorkbook.createWorksheet((String)object);
                } else {
                    if (this._scenarioMode != 0) {
                        this._scenarioStream.println("copy worksheet " + (String)object2 + " to " + (String)object);
                    }
                    excelWorkbook.copyWorksheet((String)object2, (String)object);
                }
            }
            if ((object4 = excelWorkbook.getWorksheet((String)object)) == null) {
                throw new FlowException(this.getMessage(M_FAIL_TO_CREATE_SHEET, object));
            }
            hashMap.put(object2, (Value)object4);
        }
        for (n2 = 0; n2 < excelMapping.getCellCount(); ++n2) {
            object3 = excelMapping.getCellMapping(n2);
            object2 = (ExcelWorksheet)hashMap.get(((ExcelCellMapping)object3).getSheetName());
            if (object2 == null || this._cellValues[n2] == null) continue;
            if (this._scenarioMode != 0) {
                this._scenarioStream.println("write cell " + object2.getSheetName() + "!" + ((ExcelCellMapping)object3).getAddress() + " as " + this.valueToString(this._cellValues[n2]));
                if (this._scenarioMode == 1) continue;
            }
            this.writeCellValue((ExcelWorksheet)object2, ((ExcelCellMapping)object3).getAddress(), this._cellValues[n2], this._cellAttrs[n2]);
        }
        for (n2 = 0; n2 < excelMapping.getRecordCount(); ++n2) {
            int n4;
            ExcelWorksheet excelWorksheet;
            object3 = this._records[n2];
            object2 = this._recordAttrs[n2];
            object = excelMapping.getRecordMapping(n2);
            int n5 = ((ExcelRecordMapping)object).getRowCount();
            boolean bl2 = false;
            for (int i = 0; i < ((ExcelRecordMapping)object).getFieldCount(); ++i) {
                if (!((ExcelRecordMapping)object).getFieldMapping(i).isKey()) continue;
                bl2 = true;
                break;
            }
            if ((excelWorksheet = (ExcelWorksheet)hashMap.get(((ExcelCellMapping)object).getSheetName())) == null) continue;
            if (n == 0 || n == 5) {
                int n6 = ((ExcelRecordMapping)object).getStartRow();
                n4 = 0;
                while (n4 < ((ArrayList)object3).size()) {
                    if (n6 + n5 - 1 > ((ExcelRecordMapping)object).getLastRow()) {
                        throw new FlowException(this.getMessage(M_RECORD_OVERFLOW));
                    }
                    this.writeRecord((ExcelRecordMapping)object, excelWorksheet, n6, (Value[])((ArrayList)object3).get(n4), (ExcelCellAttributes[])((ArrayList)object2).get(n4));
                    ++n4;
                    n6 += n5;
                }
                if (n != 0) continue;
                while (n6 <= ((ExcelRecordMapping)object).getLastRow()) {
                    this.deleteRecord((ExcelRecordMapping)object, excelWorksheet, n6);
                    n6 += n5;
                }
                continue;
            }
            if (!bl2 && n == 4) {
                for (int i = ((ExcelRecordMapping)object).getStartRow(); i <= ((ExcelRecordMapping)object).getLastRow(); i += n5) {
                    this.deleteRecord((ExcelRecordMapping)object, excelWorksheet, i);
                }
                continue;
            }
            RecordRange recordRange = new RecordRange(excelWorksheet, (ExcelRecordMapping)object, this._allowBlankRecord.booleanValue());
            for (n4 = 0; n4 < ((ArrayList)object3).size(); ++n4) {
                int n7;
                Value[] valueArray = (Value[])((ArrayList)object3).get(n4);
                ExcelCellAttributes[] excelCellAttributesArray = (ExcelCellAttributes[])((ArrayList)object2).get(n4);
                int n8 = -1;
                int n9 = ((ExcelRecordMapping)object).getStartRow();
                while (n9 >= 0 && (n7 = recordRange.match(n9, valueArray)) != -1 && n7 != -2) {
                    if (n7 == 1) {
                        n8 = n9;
                        break;
                    }
                    n9 = ((ExcelRecordMapping)object).getNextRow(n9);
                }
                if (n8 == -1) {
                    if (n == 1 || n == 3) {
                        if (recordRange.isFull()) {
                            throw new FlowException(this.getMessage(M_RECORD_OVERFLOW));
                        }
                        recordRange.append(valueArray, excelCellAttributesArray);
                        continue;
                    }
                    if (n == 2) {
                        if (recordRange.isFull()) {
                            throw new FlowException(this.getMessage(M_RECORD_OVERFLOW));
                        }
                        recordRange.insert(recordRange.getStartRow(), valueArray, excelCellAttributesArray);
                        continue;
                    }
                    if (n != 4) continue;
                    StringBuilder stringBuilder = new StringBuilder();
                    for (int i = 0; i < ((ExcelRecordMapping)object).getFieldCount(); ++i) {
                        ExcelFieldMapping excelFieldMapping = ((ExcelRecordMapping)object).getFieldMapping(i);
                        if (!excelFieldMapping.isKey()) continue;
                        if (stringBuilder.length() != 0) {
                            stringBuilder.append(',');
                        }
                        stringBuilder.append(excelFieldMapping.getName()).append('=').append(valueArray[i].toString());
                    }
                    this._executeContext.warn(this.getMessage(M_NO_SUCH_RECORD, stringBuilder.toString()));
                    continue;
                }
                if (n == 1 || n == 2) {
                    if (n == 1) {
                        while ((n7 = recordRange.match(n8 += n5, valueArray)) == 1) {
                        }
                    }
                    if (recordRange.isFull()) {
                        throw new FlowException(this.getMessage(M_RECORD_OVERFLOW));
                    }
                    recordRange.insert(n8, valueArray, excelCellAttributesArray);
                    continue;
                }
                if (n == 3) {
                    recordRange.update(n8, valueArray, excelCellAttributesArray);
                    continue;
                }
                if (n != 4) continue;
                recordRange.remove(n8);
            }
            recordRange.flushToWorkSheet(this, n);
        }
        try {
            byArray = excelWorkbook.close(this._filePath, this._updateFile.booleanValue() && this._filePath != null, true);
            if (this._updateFile.booleanValue() && this._filePath != null && this._scenarioMode != 0) {
                this._scenarioStream.println("close workbook " + this._filePath);
            }
        }
        catch (IOException iOException) {
            this._executeContext.error((Throwable)iOException);
            throw new FlowException((Exception)iOException);
        }
        return byArray;
    }

    private void writeRecord(ExcelRecordMapping excelRecordMapping, ExcelWorksheet excelWorksheet, int n, Value[] valueArray, ExcelCellAttributes[] excelCellAttributesArray) throws FlowException {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < excelRecordMapping.getFieldCount(); ++i) {
            ExcelFieldMapping excelFieldMapping = excelRecordMapping.getFieldMapping(i);
            stringBuilder.setLength(0);
            stringBuilder.append(excelFieldMapping.getColumn()).append(n + excelFieldMapping.getRow());
            if (this._scenarioMode != 0) {
                this._scenarioStream.println("write cell " + excelWorksheet.getSheetName() + "!" + stringBuilder + " as " + this.valueToString(valueArray[i]));
                if (this._scenarioMode == 1) continue;
            }
            this.writeCellValue(excelWorksheet, stringBuilder.toString(), valueArray[i], excelFieldMapping.getAttrCount() > 0 ? excelCellAttributesArray[i] : null);
        }
    }

    private String valueToString(Value value) {
        if (value != null && !value.isNull()) {
            Value.Type type = value.getType();
            if (type == Value.TYPE_STRING) {
                return "\"" + value.toString() + "\"";
            }
            double d = Double.NaN;
            if (type == Value.TYPE_INTEGER || type == Value.TYPE_DECIMAL) {
                int n;
                double d2 = value.longValue();
                if (d2 == (double)(n = value.intValue())) {
                    return String.valueOf(n);
                }
                d = d2;
            } else if (type == Value.TYPE_DATETIME) {
                d = value.dateValue().getTime();
                d /= 8.64E7;
                d += 25569.0;
            } else if (type == Value.TYPE_DOUBLE) {
                d = value.doubleValue();
            }
            if (!Double.isNaN(d)) {
                return String.valueOf(d);
            }
        }
        return "null";
    }

    private void writeCellValue(ExcelWorksheet excelWorksheet, String string, Value value, ExcelCellAttributes excelCellAttributes) throws FlowException {
        try {
            if (value != null && (!value.isNull() || this._convertNullToZero)) {
                Value.Type type = value.getType();
                if (type == Value.TYPE_STRING) {
                    excelWorksheet.setValue(string, value.toString(), excelCellAttributes);
                    return;
                }
                double d = Double.NaN;
                if (type == Value.TYPE_INTEGER || type == Value.TYPE_DECIMAL) {
                    long l;
                    double d2 = value.doubleValue();
                    if (d2 == (double)(l = value.longValue())) {
                        excelWorksheet.setValue(string, new Long(l), excelCellAttributes);
                        return;
                    }
                    d = d2;
                } else {
                    if (type == Value.TYPE_BOOLEAN) {
                        if (this._excelUtil.booleanSupported()) {
                            excelWorksheet.setValue(string, value.booleanValue() ? Boolean.TRUE : Boolean.FALSE, excelCellAttributes);
                            return;
                        }
                        excelWorksheet.setValue(string, new Long(value.longValue()), excelCellAttributes);
                        return;
                    }
                    if (type == Value.TYPE_DATETIME) {
                        if (this._excelUtil.dateSupported()) {
                            excelWorksheet.setValue(string, value.dateValue(), excelCellAttributes);
                            return;
                        }
                        d = ExcelUtil.dateToDouble(value.dateValue(), this._calendar);
                    } else if (type == Value.TYPE_DOUBLE) {
                        d = value.doubleValue();
                    }
                }
                if (!Double.isNaN(d)) {
                    excelWorksheet.setValue(string, new Double(d), excelCellAttributes);
                    return;
                }
            }
            excelWorksheet.setValue(string, "", excelCellAttributes);
        }
        catch (Exception exception) {
            if (this._scenarioMode != 0) {
                exception.printStackTrace();
            }
            throw new FlowException(this.getMessage(M_FAIL_TO_WRITE_CELL, string + ',' + this.valueToString(value) + ',' + exception.toString()));
        }
    }

    private void moveRecord(ExcelRecordMapping excelRecordMapping, ExcelWorksheet excelWorksheet, int n, int n2) throws FlowException {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        for (int i = 0; i < excelRecordMapping.getFieldCount(); ++i) {
            ExcelFieldMapping excelFieldMapping = excelRecordMapping.getFieldMapping(i);
            stringBuilder.setLength(0);
            stringBuilder.append(excelFieldMapping.getColumn()).append(n + excelFieldMapping.getRow());
            stringBuilder2.setLength(0);
            stringBuilder2.append(excelFieldMapping.getColumn()).append(n2 + excelFieldMapping.getRow());
            if (this._scenarioMode != 0) {
                this._scenarioStream.println("move cell " + excelWorksheet.getSheetName() + "!" + stringBuilder + " to " + stringBuilder2);
                if (this._scenarioMode == 1) continue;
            }
            try {
                Object object = excelWorksheet.getValue(stringBuilder.toString());
                if (object == null || object instanceof String && ((String)object).length() == 0) {
                    excelWorksheet.clearValue(stringBuilder2.toString());
                    continue;
                }
                excelWorksheet.setValue(stringBuilder2.toString(), object, null);
                continue;
            }
            catch (Exception exception) {
                if (this._scenarioMode != 0) {
                    exception.printStackTrace();
                }
                throw new FlowException(this.getMessage(M_FAIL_TO_MOVE_CELL, stringBuilder.toString() + ',' + stringBuilder2 + ',' + exception.toString()));
            }
        }
    }

    private void deleteRecord(ExcelRecordMapping excelRecordMapping, ExcelWorksheet excelWorksheet, int n) throws FlowException {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < excelRecordMapping.getFieldCount(); ++i) {
            ExcelFieldMapping excelFieldMapping = excelRecordMapping.getFieldMapping(i);
            stringBuilder.setLength(0);
            stringBuilder.append(excelFieldMapping.getColumn()).append(n + excelFieldMapping.getRow());
            if (this._scenarioMode != 0) {
                this._scenarioStream.println("remove cell " + excelWorksheet.getSheetName() + "!" + stringBuilder);
                if (this._scenarioMode == 1) continue;
            }
            try {
                excelWorksheet.clearValue(stringBuilder.toString());
                continue;
            }
            catch (Exception exception) {
                if (this._scenarioMode != 0) {
                    exception.printStackTrace();
                }
                throw new FlowException(this.getMessage(M_FAIL_TO_REMOVE_CELL, stringBuilder.toString() + ',' + exception.toString()));
            }
        }
    }

    private int getAccessMode() throws PropertyException {
        String string = this._outputMode.strValue();
        if (S_MODE_OVERRIDE.equals(string)) {
            return 0;
        }
        if (S_MODE_OVERRIDE_NON_CLEAR.equals(string)) {
            return 5;
        }
        if (S_MODE_APPEND.equals(string)) {
            return 1;
        }
        if (S_MODE_INSERT.equals(string)) {
            return 2;
        }
        if (S_MODE_UPDATE.equals(string)) {
            return 3;
        }
        if (S_MODE_DELETE.equals(string)) {
            return 4;
        }
        return -1;
    }

    protected ComponentCompiler getCompiler() {
        return new ExcelMappingCompiler((Component)this, false);
    }

    public ComponentEntrance getComponentEntrance() {
        ComponentEntrance componentEntrance = super.getComponentEntrance();
        ExcelMapping excelMapping = this._mappingProperty.getMapping();
        if (excelMapping == null) {
            return componentEntrance;
        }
        for (int i = 1; i < excelMapping.getRecordCount(); ++i) {
            ExcelRecordMapping excelRecordMapping = excelMapping.getRecordMapping(i);
            String string = excelRecordMapping.getConnectorName();
            if (componentEntrance.getSubConnector(string) != null) continue;
            componentEntrance.addSubConnector(string, new InputConnector(16, true));
        }
        return componentEntrance;
    }

    public void init(ExecuteContext executeContext) throws FlowException {
        this._excelUtil = S_LIBRARY_JNI_WRAPPER.equals(this._externalLibrary.strValue()) ? ExcelUtil.getInstance(1) : (S_LIBRARY_JEXCEL_API.equals(this._externalLibrary.strValue()) || S_LIBRARY_JEXCEL_API2.equals(this._externalLibrary.strValue()) ? ExcelUtil.getInstance(2) : ExcelUtil.getInstance(0));
        if (!this._excelUtil.initialize()) {
            throw new FlowException(this.getMessage(M_ERROR_IN_EXTERNAL_LIBRARY, "no native excel available"));
        }
        this._records = new ArrayList[this._mappingProperty.getMapping().getRecordCount()];
        this._recordAttrs = new ArrayList[this._mappingProperty.getMapping().getRecordCount()];
        for (int i = 0; i < this._records.length; ++i) {
            this._records[i] = new ArrayList();
            this._recordAttrs[i] = new ArrayList();
        }
        super.init(executeContext);
    }

    public void term(ExecuteContext executeContext) {
        this._excelUtil.terminate();
    }

    public boolean execute(ExecuteContext executeContext) throws FlowException {
        Object object;
        this._executeContext = executeContext;
        this._scenarioMode = this._scenarioModeProperty.booleanValue() ? 2 : 0;
        this._filePath = null;
        if (this._outputFilePath.getValue() != null && this._outputFilePath.strValue().length() != 0) {
            this._filePath = this._homeMode.getFilePath(executeContext, this._outputFilePath.strValue());
        }
        int n = this.getAccessMode();
        this._convertNullToZero = this._convertNullMode.strValue().equals(S_CONVERT_NULL_TO_ZERO);
        this.readRecord(n);
        this.readCells();
        if (this._scenarioMode != 0) {
            int n2 = this._filePath.lastIndexOf(46);
            object = (n2 == -1 ? this._filePath : this._filePath.substring(0, n2)) + ".sce";
            try {
                this._scenarioStream = new PrintStream((OutputStream)new BufferedOutputStream(new FileOutputStream((String)object, true)), true, "utf-8");
            }
            catch (Exception exception) {
                throw new FlowException(exception);
            }
            this._scenarioStream.println(this._filePath != null ? "open workbook " + this._filePath : "create workbook");
        }
        byte[] byArray = null;
        try {
            byArray = this.writeWorkBook(this._filePath, n);
        }
        catch (FlowException flowException) {
            throw flowException;
        }
        catch (Exception exception) {
            executeContext.error((Throwable)exception);
            throw new FlowException(this.getMessage(M_ERROR_IN_EXTERNAL_LIBRARY, exception.toString()));
        }
        if (this._scenarioMode != 0) {
            this._scenarioStream.close();
            this._scenarioStream = null;
        }
        object = this.getOutputConnector().getStreamFactory();
        StreamDataObject streamDataObject = object.create(byArray);
        this.getOutputConnector().setStream(streamDataObject);
        return true;
    }

    private class RecordRange
    extends ExcelRecordMapping {
        ArrayList _cache;
        ArrayList _cacheAttr;
        ExcelWorksheet _sheet;
        int _cacheMax;
        private static final int OUT_OF_RANGE = -2;
        private static final int NO_KEY = -1;
        private static final int NOT_MATCHED = 0;
        private static final int MATCHED = 1;

        RecordRange(ExcelWorksheet excelWorksheet, ExcelRecordMapping excelRecordMapping, boolean bl) {
            int n;
            super(excelRecordMapping);
            this._cache = new ArrayList();
            this._cacheAttr = new ArrayList();
            this._sheet = excelWorksheet;
            for (n = this.getLastRow() - this.getRowCount() + 1; n >= this.getStartRow() && ExcelOutputComponent.isBlankRecord(excelWorksheet, this, n, bl); n -= this.getRowCount()) {
            }
            this._cacheMax = n >= this.getStartRow() ? (n - this.getStartRow()) / this.getRowCount() + 1 : 0;
            this._cache = this._cacheMax > 0 ? new ArrayList<Object>(Collections.nCopies(this._cacheMax, null)) : new ArrayList();
            this._cacheAttr = this._cacheMax > 0 ? new ArrayList<Object>(Collections.nCopies(this._cacheMax, null)) : new ArrayList();
        }

        boolean isFull() {
            return this._cache.size() * this.getRowCount() > this.getLastRow() - this.getStartRow();
        }

        private void fillWithRowNumber(int n) {
            Object e;
            for (int i = n; i < this._cache.size() && !((e = this._cache.get(i)) instanceof Integer); ++i) {
                if (e != null) continue;
                this._cache.set(i, new Integer(this.getStartRow() + i * this.getRowCount()));
                this._cacheAttr.set(i, new Integer(this.getStartRow() + i * this.getRowCount()));
            }
        }

        int match(int n, Value[] valueArray) {
            if (n < this.getStartRow() || n - this.getStartRow() >= this._cache.size() * this.getRowCount()) {
                return -2;
            }
            Object e = this._cache.get((n - this.getStartRow()) / this.getRowCount());
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = true;
            boolean bl2 = false;
            for (int i = 0; i < this.getFieldCount(); ++i) {
                Value value;
                ExcelFieldMapping excelFieldMapping = this.getFieldMapping(i);
                if (!excelFieldMapping.isKey()) continue;
                bl2 = true;
                Value value2 = null;
                if (e instanceof Value[]) {
                    value = (Value)e;
                    if (value == null || i >= ((Value[])value).length) {
                        bl = false;
                        break;
                    }
                    value2 = value[i];
                } else {
                    if (e instanceof Integer) {
                        n = (Integer)e;
                    }
                    try {
                        stringBuilder.setLength(0);
                        stringBuilder.append(excelFieldMapping.getColumn()).append(n + excelFieldMapping.getRow());
                        value2 = ExcelUtil.cellToValue(this._sheet.getValue(stringBuilder.toString()), excelFieldMapping.getType(), ExcelOutputComponent.this._calendar);
                    }
                    catch (ValueConvertException valueConvertException) {
                        bl = false;
                        break;
                    }
                    if (value2 == null) {
                        bl = false;
                        break;
                    }
                }
                value = valueArray[i];
                if (value2 == null) {
                    if (value == null) continue;
                    bl = false;
                    break;
                }
                String string = value2.toString();
                if (value != null && string.equals(value.toString())) continue;
                bl = false;
                break;
            }
            if (!bl2) {
                return -1;
            }
            return bl ? 1 : 0;
        }

        void append(Value[] valueArray, ExcelCellAttributes[] excelCellAttributesArray) {
            if (this.isFull()) {
                throw new ArrayIndexOutOfBoundsException();
            }
            this._cache.add(valueArray);
            this._cacheAttr.add(excelCellAttributesArray);
        }

        void update(int n, Value[] valueArray, ExcelCellAttributes[] excelCellAttributesArray) {
            if (n < this.getStartRow() || n > this.getLastRow() - this.getRowCount() + 1) {
                throw new ArrayIndexOutOfBoundsException();
            }
            int n2 = (n - this.getStartRow()) / this.getRowCount();
            this._cache.set(n2, valueArray);
            this._cacheAttr.set(n2, excelCellAttributesArray);
        }

        void insert(int n, Value[] valueArray, ExcelCellAttributes[] excelCellAttributesArray) {
            if (this.isFull() || n < this.getStartRow() || n > this.getLastRow() - this.getRowCount() + 1) {
                throw new ArrayIndexOutOfBoundsException();
            }
            int n2 = (n - this.getStartRow()) / this.getRowCount();
            this.fillWithRowNumber(n2);
            this._cache.add(n2, valueArray);
            this._cacheAttr.add(n2, excelCellAttributesArray);
        }

        void remove(int n) {
            if (n < this.getStartRow() || n > this.getLastRow() - this.getRowCount() + 1) {
                throw new ArrayIndexOutOfBoundsException();
            }
            int n2 = (n - this.getStartRow()) / this.getRowCount();
            this.fillWithRowNumber(n2 + this.getRowCount());
            this._cache.remove(n2);
            this._cacheAttr.remove(n2);
        }

        void flushToWorkSheet(ExcelOutputComponent excelOutputComponent, int n) throws FlowException {
            if (n != 4) {
                for (int i = this._cache.size() - 1; i >= 0; --i) {
                    Object e = this._cache.get(i);
                    if (e == null) continue;
                    if (e instanceof Value[]) {
                        Value[] valueArray = (Value[])e;
                        ExcelCellAttributes[] excelCellAttributesArray = (ExcelCellAttributes[])this._cacheAttr.get(i);
                        excelOutputComponent.writeRecord(this, this._sheet, this.getStartRow() + i * this.getRowCount(), valueArray, excelCellAttributesArray);
                        continue;
                    }
                    if (!(e instanceof Integer)) continue;
                    int n2 = (Integer)e;
                    excelOutputComponent.moveRecord(this, this._sheet, n2, this.getStartRow() + i * this.getRowCount());
                }
            } else {
                int n3;
                for (n3 = 0; n3 < this._cache.size(); ++n3) {
                    Object e = this._cache.get(n3);
                    if (e == null || !(e instanceof Integer)) continue;
                    int n4 = (Integer)e;
                    excelOutputComponent.moveRecord(this, this._sheet, n4, this.getStartRow() + n3 * this.getRowCount());
                }
                for (n3 = this._cache.size(); n3 < this._cacheMax; ++n3) {
                    excelOutputComponent.deleteRecord(this, this._sheet, this.getStartRow() + n3 * this.getRowCount());
                }
            }
        }
    }
}

