/*
 * Decompiled with CFR 0.152.
 */
package com.infoteria.asteria.flowlibrary2.component.format;

import com.infoteria.asteria.flowengine2.compile.CompileException;
import com.infoteria.asteria.flowengine2.flow.Component;
import com.infoteria.asteria.flowengine2.flow.ComponentCompiler;
import com.infoteria.asteria.flowengine2.flow.ComponentEntrance;
import com.infoteria.asteria.flowengine2.flow.ComponentHelper;
import com.infoteria.asteria.flowengine2.flow.ComponentLink;
import com.infoteria.asteria.flowengine2.flow.InputConnector;
import com.infoteria.asteria.flowengine2.flow.OutputConnector;
import com.infoteria.asteria.flowengine2.resource.CompileInfo;
import com.infoteria.asteria.flowlibrary2.component.format.ExcelCellMapping;
import com.infoteria.asteria.flowlibrary2.component.format.ExcelFieldMapping;
import com.infoteria.asteria.flowlibrary2.component.format.ExcelMapping;
import com.infoteria.asteria.flowlibrary2.component.format.ExcelMappingProperty;
import com.infoteria.asteria.flowlibrary2.component.format.ExcelRecordMapping;
import com.infoteria.asteria.flowlibrary2.component.format.ExcelUtil;
import com.infoteria.asteria.flowlibrary2.property.Property;
import com.infoteria.asteria.flowlibrary2.property.SimpleCategoryProperty;
import com.infoteria.asteria.flowlibrary2.stream.FieldType;
import com.infoteria.asteria.flowlibrary2.stream.StreamFactory;
import com.infoteria.asteria.value.Value;
import java.util.HashMap;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ExcelMappingCompiler
extends ComponentCompiler {
    public static final int M_INVALID_EMF_CONTENTS = 1;
    public static final int M_INVALID_CELL_ADDRESS = 2;
    public static final int M_INVALID_CELL_COLUMN = 3;
    public static final int M_UNKNOWN_CELL = 4;
    public static final int M_UNKNOWN_FIELD = 5;
    public static final int M_INVALID_RECORD_ROWS = 6;
    public static final int M_INVALID_CELL_ROW = 7;
    public static final int M_INVALID_CELL_ATTRS = 8;
    public static final String P_EMF = "EMF";
    public static final String P_CELL = "Cell";
    public static final String CELLATTR_SUFFIX_BACKGROUND = "_Background";
    public static final String CELLATTR_SUFFIX_FOREGROUND = "_FontColor";
    public static final String CELLATTR_SUFFIX_FONT_NAME = "_FontName";
    public static final String CELLATTR_SUFFIX_FONT_SIZE = "_FontSize";
    public static final String CELLATTR_SUFFIX_FONT_STYLE = "_FontStyle";
    public static final String CELLATTR_SUFFIX_FORMAT_PATTERN = "_Format";
    public static final String CELLATTR_SUFFIX_FORMULA = "_Formula";
    public static final String CELLATTR_SUFFIX_COMMENT = "_Comment";
    private static final String _E_VIEWTEMP = "viewtemplate";
    private static final String _E_COMPONENT = "component";
    private static final String _E_HEADER = "header";
    private static final String _E_TEXT = "text";
    private static final String _E_RECORDS = "records";
    private static final String _E_TABLE = "table";
    private static final String _E_RECORD = "record";
    private static final String _E_FIELD = "field";
    private static final String _A_NAME = "name";
    private static final String _A_AREA = "area";
    private static final String _A_RECORD_ROWS = "recRows";
    private static final String _A_ROW = "row";
    private static final String _A_KEY = "key";
    private static final String _KEY_YES = "Yes";
    private static final String _A_END_COND = "endCondition";
    private static final String _A_USE_FORMAT = "useFormat";
    private static final String _USE_FORMAT_YES = "Yes";
    private static final String _USE_FORMAT_NO = "No";
    private static final boolean _useRecNameAsConnectorName = false;
    private boolean _bInput;

    public ExcelMappingCompiler(Component component, boolean bl) {
        super(component);
        this._bInput = bl;
    }

    public void preCompile(Element element) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            Property property;
            String string;
            if (node.getNodeType() != 1 || !this.isFlowNode(node, "Property") || !P_EMF.equals(string = ((Element)node).getAttribute(_A_NAME)) || (property = this._component.getProperty(string)) == null) continue;
            this.processEMFProperty(property, (Element)node);
        }
        super.preCompile(element);
    }

    protected boolean processOtherProperty(Property property, Element element) {
        return property.getType() == ExcelMappingProperty.PROPERTY_EXCEL_MAPPING;
    }

    private boolean processEMFProperty(Property property, Element element) {
        Object object;
        Node node;
        if (property.getType() != ExcelMappingProperty.PROPERTY_EXCEL_MAPPING) {
            return false;
        }
        Node node2 = null;
        for (node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !node.getLocalName().equals(_E_VIEWTEMP)) continue;
            node2 = (Element)node;
            break;
        }
        node = null;
        if (node2 != null) {
            for (object = node2.getFirstChild(); object != null; object = object.getNextSibling()) {
                if (object.getNodeType() != 1 || !object.getLocalName().equals(_E_COMPONENT)) continue;
                node = (Element)object;
                break;
            }
        }
        if (node == null) {
            this.onComponentError(1);
            return true;
        }
        object = new ExcelMapping();
        int n = 0;
        int n2 = 0;
        String[] stringArray = null;
        String string = node.getAttribute(_A_USE_FORMAT);
        if (string.length() != 0) {
            try {
                n = Integer.parseInt(string);
                n2 = ExcelUtil.getCellAttrCount(n);
                stringArray = ExcelUtil.getCellAttrSuffix(n, new String[n2]);
            }
            catch (NumberFormatException numberFormatException) {
                this.onComponentError(8, string);
            }
        }
        for (Node node3 = node.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
            int n3;
            Object object2;
            String string2;
            String string3;
            Node node4;
            if (node3.getNodeType() != 1) continue;
            if (node3.getLocalName().equals(_E_HEADER)) {
                for (node4 = node3.getFirstChild(); node4 != null; node4 = node4.getNextSibling()) {
                    if (node4.getNodeType() != 1 || !node4.getLocalName().equals(_E_TEXT)) continue;
                    string3 = ((Element)node4).getAttribute(_A_NAME);
                    string2 = ((Element)node4).getAttribute(_A_AREA);
                    try {
                        object2 = new ExcelCellMapping(string3, string2);
                        ((ExcelMapping)object).addCellMapping((ExcelCellMapping)object2);
                        string = ((Element)node4).getAttribute(_A_USE_FORMAT);
                        if (string.length() == 0) continue;
                        if ("Yes".equals(string)) {
                            ((ExcelCellMapping)object2).setAttrInfo(n, n2, stringArray);
                            continue;
                        }
                        if (_USE_FORMAT_NO.equals(string)) continue;
                        try {
                            n3 = Integer.parseInt(string);
                            int n4 = ExcelUtil.getCellAttrCount(n3);
                            ((ExcelCellMapping)object2).setAttrInfo(n3, n4, ExcelUtil.getCellAttrSuffix(n3, new String[n4]));
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.onComponentError(8, string);
                        }
                        continue;
                    }
                    catch (Exception exception) {
                        this.onComponentError(2, string2);
                    }
                }
                continue;
            }
            if (!node3.getLocalName().equals(_E_RECORDS)) continue;
            block20: for (node4 = node3.getFirstChild(); node4 != null; node4 = node4.getNextSibling()) {
                ExcelRecordMapping excelRecordMapping;
                if (node4.getNodeType() != 1 || !node4.getLocalName().equals(_E_TABLE)) continue;
                string3 = ((Element)node4).getAttribute(_A_NAME);
                string2 = ((Element)node4).getAttribute(_A_AREA);
                object2 = ((Element)node4).getAttribute(_A_RECORD_ROWS);
                n3 = 1;
                if (((String)object2).length() != 0) {
                    n3 = -1;
                    try {
                        n3 = Integer.parseInt((String)object2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (n3 <= 0) {
                        this.onComponentError(6, object2);
                        n3 = 1;
                    }
                }
                try {
                    excelRecordMapping = new ExcelRecordMapping(string3, string2, n3);
                }
                catch (Exception exception) {
                    this.onComponentError(2, string2);
                    continue;
                }
                ((ExcelMapping)object).addRecordMapping(excelRecordMapping);
                excelRecordMapping.setConnectorName(String.valueOf(((ExcelMapping)object).getRecordCount()));
                for (Node node5 = node4.getFirstChild(); node5 != null; node5 = node5.getNextSibling()) {
                    if (node5.getNodeType() != 1 || !node5.getLocalName().equals(_E_RECORD)) continue;
                    for (Node node6 = node5.getFirstChild(); node6 != null; node6 = node6.getNextSibling()) {
                        String string4;
                        if (node6.getNodeType() != 1 || !node6.getLocalName().equals(_E_FIELD) || (string4 = ((Element)node6).getAttribute(_A_NAME)).length() == 0) continue;
                        String string5 = ((Element)node6).getAttribute(_A_AREA);
                        int n5 = 0;
                        String string6 = ((Element)node6).getAttribute(_A_ROW);
                        if (string6.length() != 0) {
                            try {
                                n5 = Integer.parseInt(string6);
                            }
                            catch (NumberFormatException numberFormatException) {
                                this.onComponentError(7, string6);
                            }
                        }
                        boolean bl = "Yes".equals(((Element)node6).getAttribute(_A_KEY));
                        Attr attr = ((Element)node6).getAttributeNode(_A_END_COND);
                        String string7 = attr == null ? null : attr.getValue();
                        try {
                            ExcelFieldMapping excelFieldMapping = new ExcelFieldMapping(string4, string5, n5, bl, string7);
                            excelRecordMapping.addFieldMapping(excelFieldMapping);
                            string = ((Element)node6).getAttribute(_A_USE_FORMAT);
                            if (string.length() == 0) continue;
                            if ("Yes".equals(string)) {
                                excelFieldMapping.setAttrInfo(n, n2, stringArray);
                                continue;
                            }
                            if (_USE_FORMAT_NO.equals(string)) continue;
                            try {
                                int n6 = Integer.parseInt(string);
                                int n7 = ExcelUtil.getCellAttrCount(n6);
                                excelFieldMapping.setAttrInfo(n6, n7, ExcelUtil.getCellAttrSuffix(n6, new String[n7]));
                            }
                            catch (NumberFormatException numberFormatException) {
                                this.onComponentError(8, string);
                            }
                            continue;
                        }
                        catch (Exception exception) {
                            this.onComponentError(3, string5);
                        }
                    }
                    continue block20;
                }
            }
        }
        ((ExcelMappingProperty)property).setMapping((ExcelMapping)object);
        return true;
    }

    public static StreamFactory getPreviousStreamFactory(InputConnector inputConnector) {
        if (inputConnector.getLinkCount() != 1) {
            return null;
        }
        ComponentLink componentLink = inputConnector.getLink(0);
        StreamFactory streamFactory = componentLink.getEntryConnector().getStreamFactory();
        if (streamFactory != null) {
            return streamFactory;
        }
        return ComponentHelper.getPreviousStreamFactory((Component)componentLink.getEntryConnector().getOwnerComponent());
    }

    protected void postCompile() {
        for (int i = 0; i < this._component.getPropertyCount(); ++i) {
            Value value;
            Object object;
            Property property = this._component.getProperty(i);
            if (property.getType() != ExcelMappingProperty.PROPERTY_EXCEL_MAPPING) continue;
            ExcelMapping excelMapping = ((ExcelMappingProperty)property).getMapping();
            for (int j = 0; j < excelMapping.getRecordCount(); ++j) {
                KeyedCategoryProperty keyedCategoryProperty;
                Object object2;
                InputConnector inputConnector;
                ComponentEntrance componentEntrance;
                ExcelRecordMapping excelRecordMapping = excelMapping.getRecordMapping(j);
                object = excelRecordMapping.getConnectorName();
                value = null;
                if (this._bInput) {
                    componentEntrance = this._component.getComponentExit("default");
                    OutputConnector outputConnector = inputConnector = j == 0 ? componentEntrance.getDefaultConnector() : componentEntrance.getSubConnector((String)object);
                    if (inputConnector == null) {
                        this.onError(CompileInfo.INVALID_SUBCONNECTOR, this._component.getName(), object);
                        continue;
                    }
                    value = inputConnector.getStreamFactory();
                } else {
                    componentEntrance = this._component.getComponentEntrance();
                    InputConnector inputConnector2 = inputConnector = j == 0 ? componentEntrance.getDefaultConnector() : componentEntrance.getSubConnector((String)object);
                    if (inputConnector == null) {
                        this.onError(CompileInfo.INVALID_SUBCONNECTOR, this._component.getName(), object);
                        continue;
                    }
                    value = ExcelMappingCompiler.getPreviousStreamFactory(inputConnector);
                }
                if (value == null) {
                    this.onError(CompileInfo.INVALID_SUBCONNECTOR, this._component.getName(), object);
                    continue;
                }
                componentEntrance = value.getFieldDefinition();
                if (componentEntrance == null) {
                    this.onError(CompileInfo.INVALID_SUBCONNECTOR, this._component.getName(), object);
                    continue;
                }
                if (j >= excelMapping.getRecordCount()) break;
                for (int k = 0; k < excelRecordMapping.getFieldCount(); ++k) {
                    ExcelFieldMapping excelFieldMapping = excelRecordMapping.getFieldMapping(k);
                    object2 = componentEntrance.getField(excelFieldMapping.getName());
                    if (object2 == null) {
                        this.onComponentError(5, excelFieldMapping.getName());
                        continue;
                    }
                    excelFieldMapping.setType(FieldType.toValueType((FieldType)object2.getType()));
                }
                if (this._bInput || (keyedCategoryProperty = (KeyedCategoryProperty)this._component.getProperty("Field(Input)")) == null) continue;
                for (int k = 0; k < excelRecordMapping.getFieldCount(); ++k) {
                    object2 = excelRecordMapping.getFieldMapping(k);
                    Boolean bl = keyedCategoryProperty.getKeyed(((ExcelFieldMapping)object2).getName());
                    if (bl == null) continue;
                    ((ExcelFieldMapping)object2).setKeyed(bl);
                }
            }
            SimpleCategoryProperty simpleCategoryProperty = (SimpleCategoryProperty)this._component.getProperty(P_CELL);
            for (int j = 0; j < excelMapping.getCellCount(); ++j) {
                object = excelMapping.getCellMapping(j);
                Value value2 = value = simpleCategoryProperty == null ? null : simpleCategoryProperty.getValue(((ExcelCellMapping)object).getName());
                if (value == null) {
                    this.onComponentError(4, ((ExcelCellMapping)object).getName());
                    continue;
                }
                ((ExcelCellMapping)object).setType(value.getType());
            }
        }
    }

    static class KeyedCategoryProperty
    extends SimpleCategoryProperty {
        private HashMap _mapKeyed = new HashMap();

        public KeyedCategoryProperty(String string) {
            super(string);
        }

        public void compile(Element element) throws CompileException {
            super.compile(element);
            String string = element.getAttribute("Name");
            String string2 = element.getAttribute("Key");
            Boolean bl = Boolean.valueOf(string2);
            this._mapKeyed.put(string, bl);
        }

        public Boolean getKeyed(String string) {
            return (Boolean)this._mapKeyed.get(string);
        }

        public Object clone() {
            KeyedCategoryProperty keyedCategoryProperty = (KeyedCategoryProperty)((Object)super.clone());
            keyedCategoryProperty._mapKeyed = (HashMap)this._mapKeyed.clone();
            return keyedCategoryProperty;
        }

        public void assign(Property property) {
            if (!property.getName().equals(this.getName())) {
                throw new IllegalStateException();
            }
            KeyedCategoryProperty keyedCategoryProperty = (KeyedCategoryProperty)property;
            this._mapKeyed = (HashMap)keyedCategoryProperty._mapKeyed.clone();
        }
    }
}

