/*
 * Decompiled with CFR 0.152.
 */
package com.infoteria.asteria.flowlibrary2.component.format;

import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.XLS.WorkBookException;
import com.infoteria.asteria.flowlibrary2.component.format.ExcelCellMapping;
import com.infoteria.asteria.flowlibrary2.component.format.ExcelLicenseManager;
import com.infoteria.asteria.flowlibrary2.component.format.ExcelRecordMapping;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.oro.text.GlobCompiler;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Matcher;

public class ExcelMapping {
    private List _arrCell = new ArrayList();
    private List _arrRec = new ArrayList();

    int getCellCount() {
        return this._arrCell.size();
    }

    void addCellMapping(ExcelCellMapping excelCellMapping) {
        this._arrCell.add(excelCellMapping);
    }

    ExcelCellMapping getCellMapping(int n) {
        return (ExcelCellMapping)this._arrCell.get(n);
    }

    int getRecordCount() {
        return this._arrRec.size();
    }

    void addRecordMapping(ExcelRecordMapping excelRecordMapping) {
        this._arrRec.add(excelRecordMapping);
    }

    ExcelRecordMapping getRecordMapping(int n) {
        return (ExcelRecordMapping)this._arrRec.get(n);
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length > 0) {
            ExcelLicenseManager.setExtenXLSLicense();
            int n = 0;
            boolean bl = false;
            if (n < stringArray.length && stringArray[n].equals("-s")) {
                ++n;
                bl = true;
            }
            Perl5Matcher perl5Matcher = new Perl5Matcher();
            GlobCompiler globCompiler = new GlobCompiler();
            while (n < stringArray.length) {
                File file = new File(stringArray[n]);
                File file2 = file.getParentFile();
                Pattern pattern = globCompiler.compile(file.getName());
                ExcelMapping.openFiles(file2, (PatternMatcher)perl5Matcher, pattern, bl);
                ++n;
            }
        }
    }

    public static void openFiles(File file, PatternMatcher patternMatcher, Pattern pattern, boolean bl) {
        int n;
        File[] fileArray = file.listFiles();
        for (n = 0; n < fileArray.length; ++n) {
            PatternMatcherInput patternMatcherInput;
            if (!fileArray[n].isFile() || !patternMatcher.matches(patternMatcherInput = new PatternMatcherInput(fileArray[n].getName()), pattern)) continue;
            System.out.print(fileArray[n].getAbsolutePath() + " : ");
            try {
                byte[] byArray = new byte[(int)fileArray[n].length()];
                FileInputStream fileInputStream = new FileInputStream(fileArray[n]);
                fileInputStream.read(byArray);
                fileInputStream.close();
                WorkBookHandle workBookHandle = new WorkBookHandle(byArray);
                System.out.println(workBookHandle != null ? "OK" : "NG");
                continue;
            }
            catch (WorkBookException workBookException) {
                System.out.println(workBookException.getErrorCode() == 0 ? "NG (95/97 format)" : "NG");
                continue;
            }
            catch (Throwable throwable) {
                System.out.println("NG (" + throwable.toString() + ")");
            }
        }
        if (bl) {
            for (n = 0; n < fileArray.length; ++n) {
                if (!fileArray[n].isDirectory()) continue;
                ExcelMapping.openFiles(fileArray[n], patternMatcher, pattern, true);
            }
        }
    }
}

