/*
 * Decompiled with CFR 0.152.
 */
package com.infoteria.asteria.flowlibrary2.component.format;

import com.infoteria.asteria.flowengine2.execute.ExecuteContext;
import com.infoteria.asteria.flowengine2.flow.Component;
import com.infoteria.asteria.flowengine2.flow.ComponentCompiler;
import com.infoteria.asteria.flowengine2.flow.ComponentExit;
import com.infoteria.asteria.flowengine2.flow.OutputConnector;
import com.infoteria.asteria.flowlibrary2.FlowException;
import com.infoteria.asteria.flowlibrary2.component.SimpleComponent;
import com.infoteria.asteria.flowlibrary2.component.format.ExcelCellAttributes;
import com.infoteria.asteria.flowlibrary2.component.format.ExcelCellMapping;
import com.infoteria.asteria.flowlibrary2.component.format.ExcelFieldMapping;
import com.infoteria.asteria.flowlibrary2.component.format.ExcelLicenseManager;
import com.infoteria.asteria.flowlibrary2.component.format.ExcelMapping;
import com.infoteria.asteria.flowlibrary2.component.format.ExcelMappingCompiler;
import com.infoteria.asteria.flowlibrary2.component.format.ExcelMappingProperty;
import com.infoteria.asteria.flowlibrary2.component.format.ExcelRecordMapping;
import com.infoteria.asteria.flowlibrary2.component.format.ExcelUtil;
import com.infoteria.asteria.flowlibrary2.component.format.ExcelWorkbook;
import com.infoteria.asteria.flowlibrary2.component.format.ExcelWorksheet;
import com.infoteria.asteria.flowlibrary2.property.BooleanProperty;
import com.infoteria.asteria.flowlibrary2.property.EnumProperty;
import com.infoteria.asteria.flowlibrary2.property.Property;
import com.infoteria.asteria.flowlibrary2.property.SimpleCategoryProperty;
import com.infoteria.asteria.flowlibrary2.property.StringProperty;
import com.infoteria.asteria.flowlibrary2.stream.StreamDataBinary;
import com.infoteria.asteria.flowlibrary2.stream.StreamDataObject;
import com.infoteria.asteria.flowlibrary2.stream.StreamDataRecord;
import com.infoteria.asteria.flowlibrary2.stream.StreamFactoryRecord;
import com.infoteria.asteria.value.Value;
import com.infoteria.asteria.value.ValueConvertException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;

public class ExcelInputComponent
extends SimpleComponent {
    public static final String COMPONENT_NAME = "Excel(Input)";
    public static final String M_UNKNOWN_CELL = Integer.toString(4);
    public static final String M_FAIL_TO_VALUE_CONVERSION = "200";
    public static final String M_NO_SHEETS = "201";
    public static final String M_ERROR_IN_EXTERNAL_LIBRARY = "209";
    public static final String M_UNSUPPORTED_XLS = "210";
    public static final String M_DUAL_STREAM_UNSUPPORTED = "211";
    protected static final String S_LIBRARY_EXTEN_XLS = "MultiPlatform";
    protected static final String S_LIBRARY_JNI_WRAPPER = "NativeExcel";
    protected static final String S_LIBRARY_JEXCEL_API = "MultiPlatform(Light)";
    protected static final String S_LIBRARY_JEXCEL_API2 = "MultiPlatform(Fast)";
    protected EnumProperty _externalLibrary = new EnumProperty("ExternalLibrary", false, false, "MultiPlatform");
    private BooleanProperty _loop = new BooleanProperty("LoopProcess", false, false, true);
    private BooleanProperty _ignoreBlankRow = new BooleanProperty("IgnoreBlankRow", false, true, false);
    private StringProperty _inputSheetNameProperty = new StringProperty("InputSheetName", false, true, null);
    private SimpleCategoryProperty _inputSheetNamesProperty = new SimpleCategoryProperty("Sheet");
    private SimpleCategoryProperty _cellProperty = new SimpleCategoryProperty("Cell");
    private ExcelMappingProperty _mappingProperty = new ExcelMappingProperty("EMF");
    private StringProperty _templateProperty = new StringProperty("Template");
    private BooleanProperty _autoCalculation = new BooleanProperty("AutoCalculation", false, true, false);
    private BooleanProperty _roundUpFormula = new BooleanProperty("RoundUpFormula", false, true, false);
    private Calendar _calendar = Calendar.getInstance();
    private ExcelUtil _excelUtil;
    private ExecuteContext _executeContext;
    private int _recordIndex;
    private Value[] _cellValues;
    private ExcelCellAttributes[] _cellAttrs;
    private ArrayList[] _records;

    public String getComponentName() {
        return COMPONENT_NAME;
    }

    public String getLicenseStr() {
        return ExcelLicenseManager.getLicenseStr();
    }

    public ExcelInputComponent() {
        this.getInputConnector().setAcceptContainer(false);
        this.getInputConnector().setAcceptType(1);
        this.getOutputConnector().setAcceptType(16);
        this.registProperty((Property)this._loop);
        this.registProperty((Property)this._ignoreBlankRow);
        this.registProperty((Property)this._inputSheetNameProperty);
        this.registProperty((Property)this._inputSheetNamesProperty);
        this.registProperty((Property)this._cellProperty);
        this.registProperty(this._mappingProperty);
        this.registProperty((Property)this._templateProperty);
        this._externalLibrary.addEnumeration(S_LIBRARY_EXTEN_XLS);
        this._externalLibrary.addEnumeration(S_LIBRARY_JNI_WRAPPER);
        this._externalLibrary.addEnumeration(S_LIBRARY_JEXCEL_API);
        this._externalLibrary.addEnumeration(S_LIBRARY_JEXCEL_API2);
        this.registProperty((Property)this._externalLibrary);
        this.registProperty((Property)this._autoCalculation);
        this.registProperty((Property)this._roundUpFormula);
    }

    private void readWorkBook(byte[] byArray) throws FlowException {
        Object object;
        Object object2;
        Object object3;
        ExcelCellMapping excelCellMapping;
        int n;
        ExcelWorkbook excelWorkbook;
        if (byArray == null || byArray.length == 0) {
            throw new FlowException(this.getMessage(M_UNSUPPORTED_XLS));
        }
        ExcelMapping excelMapping = this._mappingProperty.getMapping();
        try {
            excelWorkbook = this._excelUtil.openWorkbook(byArray, true);
            if (excelWorkbook == null) {
                throw new FlowException(this.getMessage(M_UNSUPPORTED_XLS));
            }
            excelWorkbook.setAutoCalculation(this._autoCalculation.booleanValue());
            excelWorkbook.setRoundUpFormula(this._roundUpFormula.booleanValue());
        }
        catch (ExcelUtil.DualStreamException dualStreamException) {
            throw new FlowException(this.getMessage(M_DUAL_STREAM_UNSUPPORTED));
        }
        catch (ExcelUtil.UnsupportedExcelFileException unsupportedExcelFileException) {
            throw new FlowException(this.getMessage(M_UNSUPPORTED_XLS));
        }
        catch (IOException iOException) {
            throw new FlowException((Exception)iOException);
        }
        this._recordIndex = 0;
        String string = null;
        if (this._inputSheetNameProperty.getValue() != null && this._inputSheetNameProperty.strValue().length() != 0) {
            string = this._inputSheetNameProperty.strValue();
        }
        HashMap<Object, Value> hashMap = new HashMap<Object, Value>();
        for (n = 0; n < excelMapping.getRecordCount() + excelMapping.getCellCount(); ++n) {
            ExcelCellMapping excelCellMapping2 = excelCellMapping = n < excelMapping.getRecordCount() ? excelMapping.getRecordMapping(n) : excelMapping.getCellMapping(n - excelMapping.getRecordCount());
            if (excelCellMapping == null || hashMap.containsKey(object3 = excelCellMapping.getSheetName())) continue;
            if (string != null) {
                object2 = string;
                string = null;
            } else {
                object = this._inputSheetNamesProperty.getValue((String)object3);
                object2 = object != null && !object.isNull() && object.strValue().length() != 0 ? object.strValue() : object3;
            }
            object = excelWorkbook.getWorksheet((String)object2);
            if (object == null) {
                throw new FlowException(this.getMessage(M_NO_SHEETS, object2));
            }
            hashMap.put(object3, (Value)object);
        }
        this._cellValues = new Value[excelMapping.getCellCount()];
        this._cellAttrs = new ExcelCellAttributes[excelMapping.getCellCount()];
        for (n = 0; n < excelMapping.getCellCount(); ++n) {
            excelCellMapping = excelMapping.getCellMapping(n);
            object3 = (ExcelWorksheet)hashMap.get(excelCellMapping.getSheetName());
            if (object3 == null) continue;
            this._cellValues[n] = this.getCellValue((ExcelWorksheet)object3, excelCellMapping.getAddress(), excelCellMapping.getType());
            if (excelCellMapping.getAttrMask() == 0) continue;
            this._cellAttrs[n] = object3.getAttrbutes(excelCellMapping.getAddress(), excelCellMapping.getAttrMask());
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < excelMapping.getRecordCount(); ++i) {
            int n2;
            int n3;
            object3 = this._records[i];
            ((ArrayList)object3).clear();
            object2 = excelMapping.getRecordMapping(i);
            object = (ExcelWorksheet)hashMap.get(((ExcelCellMapping)object2).getSheetName());
            if (object == null) continue;
            boolean bl = false;
            int n4 = ((ExcelRecordMapping)object2).getFieldCount();
            for (n3 = 0; n3 < ((ExcelRecordMapping)object2).getFieldCount(); ++n3) {
                ExcelFieldMapping excelFieldMapping = ((ExcelRecordMapping)object2).getFieldMapping(n3);
                n4 += excelFieldMapping.getAttrCount();
                if (excelFieldMapping.getEndCondition() == null) continue;
                bl = true;
            }
            n3 = -1;
            int n5 = ((ExcelRecordMapping)object2).getStartRow();
            while (n5 >= 0) {
                n2 = 1;
                boolean bl2 = bl;
                Value[] valueArray = new Value[n4];
                int n6 = 0;
                for (int j = 0; j < ((ExcelRecordMapping)object2).getFieldCount(); ++j) {
                    Object object4;
                    ExcelFieldMapping excelFieldMapping = ((ExcelRecordMapping)object2).getFieldMapping(j);
                    stringBuilder.setLength(0);
                    stringBuilder.append(excelFieldMapping.getColumn()).append(n5 + excelFieldMapping.getRow());
                    valueArray[n6] = this.getCellValue((ExcelWorksheet)object, stringBuilder.toString(), excelFieldMapping.getType());
                    if (!(valueArray[n6].isNull() || valueArray[n6].getType() == Value.TYPE_STRING && valueArray[n6].strValue().length() == 0)) {
                        n2 = 0;
                    }
                    if (excelFieldMapping.getEndCondition() != null) {
                        Object object5 = object4 = valueArray[n6] != null ? valueArray[n6].strValue() : null;
                        if (!(excelFieldMapping.getEndCondition().equals(object4) || excelFieldMapping.getEndCondition().length() == 0 && object4 == null)) {
                            bl2 = false;
                        }
                    }
                    ++n6;
                    if (excelFieldMapping.getAttrCount() <= 0) continue;
                    object4 = object.getAttrbutes(stringBuilder.toString(), excelFieldMapping.getAttrMask());
                    if (object4 == null) {
                        for (int k = 0; k < excelFieldMapping.getAttrCount(); ++k) {
                            valueArray[n6 + k] = Value.create(null);
                        }
                    } else {
                        ExcelUtil.getCellAttrValues((ExcelCellAttributes)object4, valueArray, n6);
                    }
                    n6 += excelFieldMapping.getAttrCount();
                }
                if (bl2) break;
                if (n2 == 0) {
                    n3 = ((ArrayList)object3).size();
                }
                if (n2 == 0 || !this._ignoreBlankRow.booleanValue()) {
                    ((ArrayList)object3).add(valueArray);
                }
                n5 = ((ExcelRecordMapping)object2).getNextRow(n5);
            }
            if (bl) continue;
            if (n3 < 0) {
                ((ArrayList)object3).clear();
                continue;
            }
            for (n2 = ((ArrayList)object3).size() - 1; n2 > n3; --n2) {
                ((ArrayList)object3).remove(n2);
            }
        }
    }

    private Value getCellValue(ExcelWorksheet excelWorksheet, String string, Value.Type type) throws FlowException {
        Object object = excelWorksheet.getValue(string);
        try {
            return ExcelUtil.cellToValue(object, type, this._calendar);
        }
        catch (ValueConvertException valueConvertException) {
            throw new FlowException(this.getMessage(M_FAIL_TO_VALUE_CONVERSION, string + ',' + (object == null ? "null" : object.toString()) + ',' + type.toString()));
        }
    }

    private void writeCellValues() throws FlowException {
        ExcelMapping excelMapping = this._mappingProperty.getMapping();
        for (int i = 0; i < excelMapping.getCellCount(); ++i) {
            ExcelCellMapping excelCellMapping = excelMapping.getCellMapping(i);
            Value value = this._cellProperty.getValue(excelCellMapping.getName());
            if (value == null) {
                this._executeContext.warn(this.getMessage(M_UNKNOWN_CELL, excelCellMapping.getName()));
                continue;
            }
            try {
                value.assign(this._cellValues == null ? null : this._cellValues[i]);
            }
            catch (ValueConvertException valueConvertException) {
                throw new FlowException(this.getMessage(M_FAIL_TO_VALUE_CONVERSION, excelCellMapping.getAddress() + ',' + this.valueToString(this._cellValues[i]) + ',' + value.getType().toString()));
            }
            if (excelCellMapping.getAttrCount() <= 0) continue;
            String[] stringArray = excelCellMapping.getAttrSuffix();
            if (this._cellAttrs[i] == null) {
                for (int j = 0; j < stringArray.length; ++j) {
                    Value value2 = this._cellProperty.getValue(excelCellMapping.getName() + stringArray[j]);
                    if (value2 == null) continue;
                    value2.setNull();
                }
                continue;
            }
            Value[] valueArray = ExcelUtil.getCellAttrValues(this._cellAttrs[i], new Value[excelCellMapping.getAttrCount()], 0);
            for (int j = 0; j < stringArray.length; ++j) {
                Value value3 = this._cellProperty.getValue(excelCellMapping.getName() + stringArray[j]);
                if (value3 == null) continue;
                value3.setValue(valueArray[j]);
            }
        }
    }

    private String valueToString(Value value) {
        if (value != null && !value.isNull()) {
            Value.Type type = value.getType();
            if (type == Value.TYPE_STRING) {
                return "\"" + value.toString() + "\"";
            }
            double d = Double.NaN;
            if (type == Value.TYPE_INTEGER || type == Value.TYPE_DECIMAL) {
                int n;
                double d2 = value.longValue();
                if (d2 == (double)(n = value.intValue())) {
                    return String.valueOf(n);
                }
                d = d2;
            } else if (type == Value.TYPE_DATETIME) {
                d = ExcelUtil.dateToDouble(value.dateValue(), this._calendar);
            } else if (type == Value.TYPE_DOUBLE) {
                d = value.doubleValue();
            }
            if (!Double.isNaN(d)) {
                return String.valueOf(d);
            }
        }
        return "null";
    }

    boolean isStart() {
        return this._recordIndex <= 1;
    }

    boolean isEnd() {
        return this._recordIndex >= this._records[0].size();
    }

    protected ComponentCompiler getCompiler() {
        return new ExcelMappingCompiler((Component)this, true);
    }

    public ComponentExit getComponentExit(String string) {
        ComponentExit componentExit = super.getComponentExit(string);
        ExcelMapping excelMapping = this._mappingProperty.getMapping();
        if (excelMapping == null) {
            return componentExit;
        }
        for (int i = 1; i < excelMapping.getRecordCount(); ++i) {
            ExcelRecordMapping excelRecordMapping = excelMapping.getRecordMapping(i);
            String string2 = excelRecordMapping.getConnectorName();
            if (componentExit.getSubConnector(string2) != null) continue;
            componentExit.addSubConnector(string2, new OutputConnector(16, true));
        }
        return componentExit;
    }

    public boolean loopPossibility() {
        return this._loop.booleanValue();
    }

    public void init(ExecuteContext executeContext) throws FlowException {
        this._excelUtil = S_LIBRARY_JNI_WRAPPER.equals(this._externalLibrary.strValue()) ? ExcelUtil.getInstance(1) : (S_LIBRARY_JEXCEL_API.equals(this._externalLibrary.strValue()) || S_LIBRARY_JEXCEL_API2.equals(this._externalLibrary.strValue()) ? ExcelUtil.getInstance(2) : ExcelUtil.getInstance(0));
        if (!this._excelUtil.initialize()) {
            throw new FlowException(this.getMessage(M_ERROR_IN_EXTERNAL_LIBRARY, "no native excel available"));
        }
        int n = this._mappingProperty.getMapping().getRecordCount();
        if (n <= 0) {
            n = 1;
        }
        this._records = new ArrayList[n];
        for (int i = 0; i < this._records.length; ++i) {
            this._records[i] = new ArrayList();
        }
        super.init(executeContext);
    }

    public void term(ExecuteContext executeContext) {
        this._excelUtil.terminate();
    }

    public boolean execute(ExecuteContext executeContext) throws FlowException {
        this._recordIndex = 0;
        this._executeContext = executeContext;
        StreamDataBinary streamDataBinary = (StreamDataBinary)this.getInputConnector().getStream();
        byte[] byArray = streamDataBinary.byteValue();
        try {
            this.readWorkBook(byArray);
        }
        catch (FlowException flowException) {
            throw flowException;
        }
        catch (Exception exception) {
            executeContext.error((Throwable)exception);
            throw new FlowException(this.getMessage(M_ERROR_IN_EXTERNAL_LIBRARY, exception.toString()));
        }
        this.writeCellValues();
        ComponentExit componentExit = this.getComponentExit("default");
        ExcelMapping excelMapping = this._mappingProperty.getMapping();
        if (!this._loop.booleanValue() || this._records[0].size() <= 0) {
            for (int i = 0; i < this._records.length; ++i) {
                OutputConnector outputConnector = i == 0 ? componentExit.getDefaultConnector() : componentExit.getSubConnector(excelMapping.getRecordMapping(i).getConnectorName());
                StreamFactoryRecord streamFactoryRecord = (StreamFactoryRecord)outputConnector.getStreamFactory();
                StreamDataRecord streamDataRecord = streamFactoryRecord.create((List)this._records[i]);
                this.setStreamVariables((StreamDataObject)streamDataRecord);
                outputConnector.setStream((StreamDataObject)streamDataRecord);
            }
            return true;
        }
        StreamFactoryRecord streamFactoryRecord = (StreamFactoryRecord)componentExit.getDefaultConnector().getStreamFactory();
        ArrayList arrayList = new ArrayList(1);
        arrayList.add(this._records[0].get(0));
        StreamDataRecord streamDataRecord = streamFactoryRecord.create(arrayList);
        this.setStreamVariables((StreamDataObject)streamDataRecord);
        this.getOutputConnector().setStream((StreamDataObject)streamDataRecord);
        this._recordIndex = 1;
        return this._recordIndex >= this._records[0].size();
    }

    public int executeLoop(ExecuteContext executeContext) throws FlowException {
        ArrayList arrayList = this._records[0];
        if (this._recordIndex >= arrayList.size()) {
            return 2;
        }
        ArrayList arrayList2 = new ArrayList(1);
        arrayList2.add(arrayList.get(this._recordIndex));
        StreamFactoryRecord streamFactoryRecord = (StreamFactoryRecord)this.getOutputConnector().getStreamFactory();
        StreamDataRecord streamDataRecord = streamFactoryRecord.create(arrayList2);
        this.setStreamVariables((StreamDataObject)streamDataRecord);
        this.getOutputConnector().setStream((StreamDataObject)streamDataRecord);
        ++this._recordIndex;
        return this._recordIndex >= arrayList.size() ? 0 : 1;
    }

    private void setStreamVariables(StreamDataObject streamDataObject) {
        for (String string : this._cellProperty.keySet()) {
            streamDataObject.putStreamVariable(string, this._cellProperty.getValue(string));
        }
    }
}

