/*
 * Decompiled with CFR 0.152.
 */
package com.infoteria.asteria.flowlibrary2.component.format;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ExcelColor {
    public static final int WHITE = 1;
    public static final int RED = 2;
    public static final int BRIGHT_GREEN = 3;
    public static final int BLUE = 4;
    public static final int YELLOW = 5;
    public static final int PINK = 6;
    public static final int TURQUOISE = 7;
    public static final int BLACK = 8;
    public static final int WHITE2 = 9;
    public static final int RED2 = 10;
    public static final int BRIGHT_GREEN2 = 11;
    public static final int BLUE2 = 12;
    public static final int YELLOW2 = 13;
    public static final int PINK2 = 14;
    public static final int TURQUOISE2 = 15;
    public static final int DARK_RED = 16;
    public static final int GREEN = 17;
    public static final int DARK_BLUE = 18;
    public static final int DARK_YELLOW = 19;
    public static final int VIOLET = 20;
    public static final int TEAL = 21;
    public static final int GRAY_25_PERCENT = 22;
    public static final int GRAY_50_PERCENT = 23;
    public static final int PERIWINKLE = 24;
    public static final int PLUM2 = 25;
    public static final int IVORY = 26;
    public static final int LIGHT_TURQUOISE = 27;
    public static final int DARK_PURPLE = 28;
    public static final int CORAL = 29;
    public static final int OCEAN_BLUE = 30;
    public static final int ICE_BLUE = 31;
    public static final int DARK_BLUE2 = 32;
    public static final int PINK3 = 33;
    public static final int YELLOW3 = 34;
    public static final int TURQUOISE3 = 35;
    public static final int VIOLET2 = 36;
    public static final int DARK_RED2 = 37;
    public static final int TEAL2 = 38;
    public static final int BLUE3 = 39;
    public static final int SKY_BLUE = 40;
    public static final int LIGHT_TURQUOISE2 = 41;
    public static final int LIGHT_GREEN = 42;
    public static final int LIGHT_YELLOW = 43;
    public static final int PALE_BLUE = 44;
    public static final int ROSE = 45;
    public static final int LAVENDER = 46;
    public static final int TAN = 47;
    public static final int LIGHT_BLUE = 48;
    public static final int AQUA = 49;
    public static final int LIME = 50;
    public static final int GOLD = 51;
    public static final int LIGHT_ORANGE = 52;
    public static final int ORANGE = 53;
    public static final int BLUE_GRAY = 54;
    public static final int GRAY_40_PERCENT = 55;
    public static final int DARK_TEAL = 56;
    public static final int SEA_GREEN = 57;
    public static final int DARK_GREEN = 58;
    public static final int OLIVE_GREEN = 59;
    public static final int BROWN = 60;
    public static final int PLUM = 61;
    public static final int INDIGO = 62;
    public static final int GRAY_80_PERCENT = 63;
    static final int AUTO = 64;
    static final int DEFAULT_BACKGROUND = 192;
    static final int DEFAULT_BACKGROUND1 = 0;
    static final int UNKNOWN = 32750;
    static final int DEFAULT_FOREGROUND = Short.MAX_VALUE;
    private static ExcelColor[] _excelColors;
    private static ExcelColor _excelColorWhite;
    private static ExcelColor _excelColorBlack;
    private static final Map _colorMap;
    private int _index;
    private String _name;

    public static ExcelColor getColor(int n) {
        if (n <= 0 || n - 1 >= _excelColors.length) {
            if (n == 192 || n == 0 || n == 64) {
                return _excelColorWhite;
            }
            if (n == Short.MAX_VALUE) {
                return _excelColorBlack;
            }
            return null;
        }
        return _excelColors[n - 1];
    }

    public static ExcelColor getColor(String string) {
        if (string != null) {
            string = string.toLowerCase().trim();
        }
        return (ExcelColor)_colorMap.get(string);
    }

    public static ExcelColor getWhiteColor() {
        return _excelColorWhite;
    }

    public static ExcelColor getBlackColor() {
        return _excelColorBlack;
    }

    public ExcelColor(int n, String string) {
        this._index = n;
        this._name = string;
    }

    public int getIndex() {
        return this._index;
    }

    public String getName() {
        return this._name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        _colorMap = new HashMap();
        Map map = _colorMap;
        synchronized (map) {
            if (_colorMap.size() == 0) {
                Object object;
                String[] stringArray = new String[]{"white", "red", "bright green", "blue", "yellow", "pink", "turquoise", "black", "white", "red", "bright green", "blue", "yellow", "pink", "turquoise", "dark red", "green", "dark blue", "dark yellow", "violet", "teal", "gray 25%", "gray 50%", "periwinkle", "plum", "ivory", "light turquoise", "dark purple", "coral", "ocean blue", "ice blue", "dark blue", "pink", "yellow", "turquoise", "violet", "dark red", "teal", "blue", "sky blue", "light turquoise", "light green", "light yellow", "pale blue", "rose", "lavender", "tan", "light blue", "aqua", "lime", "gold", "light orange", "orange", "blue gray", "gray 40%", "dark teal", "sea green", "dark green", "olive green", "brown", "plum", "indigo", "gray 80%"};
                ArrayList<ExcelColor> arrayList = new ArrayList<ExcelColor>();
                for (int i = 0; i < stringArray.length; ++i) {
                    object = stringArray[i];
                    ExcelColor excelColor = new ExcelColor(i + 1, (String)object);
                    arrayList.add(excelColor);
                    if (_colorMap.containsKey(object)) continue;
                    _colorMap.put(object, excelColor);
                    int n = ((String)object).indexOf("gray");
                    if (n == -1 || n != 0 && ((String)object).charAt(n - 1) != ' ' || n + 4 < ((String)object).length() && ((String)object).charAt(n + 4) != ' ') continue;
                    object = ((String)object).substring(0, n) + "grey" + ((String)object).substring(n + 4);
                    _colorMap.put(object, excelColor);
                }
                ExcelColor excelColor = (ExcelColor)_colorMap.get("gray 50%");
                if (excelColor != null) {
                    _colorMap.put("gray", excelColor);
                    _colorMap.put("grey", excelColor);
                }
                if ((object = (ExcelColor)_colorMap.get("light yellow")) != null) {
                    _colorMap.put("very light yellow", object);
                }
                _excelColors = arrayList.toArray(new ExcelColor[arrayList.size()]);
                _excelColorWhite = ExcelColor.getColor("white");
                _excelColorBlack = ExcelColor.getColor("black");
            }
        }
    }
}

