/*
 * Decompiled with CFR 0.152.
 */
package com.infoteria.asteria.flowlibrary2.component.format;

import com.infoteria.asteria.flowlibrary2.component.format.ExcelColor;

public class ExcelCellAttributes {
    public static final int CELLATTR_BACKGROUND_COLOR = 1;
    public static final int CELLATTR_FOREGROUND_COLOR = 2;
    public static final int CELLATTR_FONT_NAME = 4;
    public static final int CELLATTR_FONT_SIZE = 8;
    public static final int CELLATTR_FONT_STYLE = 16;
    public static final int CELLATTR_FORMAT = 32;
    public static final int CELLATTR_FORMULA = 64;
    public static final int CELLATTR_COMMENT = 128;
    private int _mask;
    private ExcelColor _writtenBackground;
    private String _writtenFontName;
    private int _writtenFontSize;
    private int _writtenFontStyle;
    private ExcelColor _writtenFontColor;
    private String _writtenFormatPattern;
    private String _writtenFormula;
    private String _writtenComment;
    public static final int PLAIN = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;

    private ExcelCellAttributes() {
    }

    public ExcelCellAttributes(int n) {
        this._mask = n;
    }

    public boolean hasCellFormat() {
        return (this._mask & 0x3F) != 0;
    }

    public boolean hasFontFormat() {
        return (this._mask & 0x1E) != 0;
    }

    public boolean hasBackgroundColor() {
        return (this._mask & 1) != 0;
    }

    public void unsetBackgroundColor() {
        this._mask &= 0xFFFFFFFE;
    }

    public boolean hasFontAttributes() {
        return (this._mask & 0x1E) != 0;
    }

    public boolean hasForegroundColor() {
        return (this._mask & 2) != 0;
    }

    public void unsetForegroundColor() {
        this._mask &= 0xFFFFFFFD;
    }

    public boolean hasFontName() {
        return (this._mask & 4) != 0;
    }

    public void unsetFontName() {
        this._mask &= 0xFFFFFFFB;
    }

    public boolean hasFontSize() {
        return (this._mask & 8) != 0;
    }

    public void unsetFontSize() {
        this._mask &= 0xFFFFFFF7;
    }

    public boolean hasFontStyle() {
        return (this._mask & 0x10) != 0;
    }

    public void unsetFontStyle() {
        this._mask &= 0xFFFFFFEF;
    }

    public boolean hasFormatPattern() {
        return (this._mask & 0x20) != 0;
    }

    public void unsetFormatPattern() {
        this._mask &= 0xFFFFFFDF;
    }

    public boolean hasFormula() {
        return (this._mask & 0x40) != 0;
    }

    public void unsetFormula() {
        this._mask &= 0xFFFFFFBF;
    }

    public boolean hasComment() {
        return (this._mask & 0x80) != 0;
    }

    public void unsetComment() {
        this._mask &= 0xFFFFFF7F;
    }

    public ExcelColor getBackgroundColor() {
        return this._writtenBackground;
    }

    public ExcelColor getForegroundColor() {
        return this._writtenFontColor;
    }

    public String getFontName() {
        return this._writtenFontName;
    }

    public int getFontSize() {
        return this._writtenFontSize;
    }

    public int getFontStyle() {
        return this._writtenFontStyle;
    }

    public String getFormatPattern() {
        return this._writtenFormatPattern;
    }

    public String getFormula() {
        return this._writtenFormula;
    }

    public String getComment() {
        return this._writtenComment;
    }

    public void setBackgroundColor(ExcelColor excelColor) {
        this._writtenBackground = excelColor;
    }

    public void setComment(String string) {
        this._writtenComment = string;
    }

    public void setFontName(String string) {
        this._writtenFontName = string;
    }

    public void setFontSize(int n) {
        this._writtenFontSize = n;
    }

    public void setFontStyle(int n) {
        this._writtenFontStyle = n;
    }

    public void setForegroundColor(ExcelColor excelColor) {
        this._writtenFontColor = excelColor;
    }

    public void setFormatPattern(String string) {
        this._writtenFormatPattern = string;
    }

    public void setFormula(String string) {
        this._writtenFormula = string;
    }
}

